/****************************************************************************************/
/*  VEC2.C                                                                              */
/*                                                                                      */
/*  Author: Jason Wood                                                                  */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/

#include <math.h>
#include <assert.h>

#include "basetype.h"
#include "vec2.h"

void jeGlyph3d_Vec2f_Set(jeGlyph3d_Vec2f* pV, float x, float y)
{
	assert(pV);

	pV->X = x;
	pV->Y = y;
}

void jeGlyph3d_Vec2f_Subtract(jeGlyph3d_Vec2f* pV1, jeGlyph3d_Vec2f* pV2, jeGlyph3d_Vec2f* pRes)
{
	assert(pV1);
	assert(pV2);
	assert(pRes);

	pRes->X = pV1->X - pV2->X;
	pRes->Y = pV1->Y - pV2->Y;
}

float jeGlyph3d_Vec2f_Length(jeGlyph3d_Vec2f* pV)
{
	assert(pV);

	return (float)sqrt(jeFloat_Sqr(pV->X) + jeFloat_Sqr(pV->Y));
}

float jeGlyph3d_Vec2f_Normalize(jeGlyph3d_Vec2f* pV)
{
	float len;
	
	assert(pV);

	len = jeGlyph3d_Vec2f_Length(pV);

	if (len >= 0.01f)
	{	
		pV->X /= len;
		pV->Y /= len;
	}

	return len;
}

float jeGlyph3d_Vec2f_DotProduct(jeGlyph3d_Vec2f* pV1, jeGlyph3d_Vec2f* pV2)
{
	assert(pV1);
	assert(pV2);

	return pV1->X * pV2->X + pV1->Y * pV2->Y;
}
