/****************************************************************************************/
/*  VEC2.H                                                                              */
/*                                                                                      */
/*  Author: Jason Wood                                                                  */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/

#ifndef VEC2_H
#define VEC2_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	int X, Y;

}jeGlyph3d_Vec2i;

typedef struct
{
	float X, Y;

}jeGlyph3d_Vec2f;

///////////////////////////////////////////////////////////////////////////////////////

void jeGlyph3d_Vec2f_Set(jeGlyph3d_Vec2f* pV, float x, float y);
void jeGlyph3d_Vec2f_Subtract(jeGlyph3d_Vec2f* pV1, jeGlyph3d_Vec2f* pV2, jeGlyph3d_Vec2f* pRes);
float jeGlyph3d_Vec2f_Length(jeGlyph3d_Vec2f* pV);
float jeGlyph3d_Vec2f_Normalize(jeGlyph3d_Vec2f* pV);
float jeGlyph3d_Vec2f_DotProduct(jeGlyph3d_Vec2f* pV1, jeGlyph3d_Vec2f* pV2);

#ifdef __cplusplus
}
#endif

#endif
