/****************************************************************************************/
/*  WGCLIP.H                                                                            */
/*                                                                                      */
/*  Author: Thom Robertson                                                              */
/*  Description: 2D rectangular clip testing support                                    */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
#ifndef JE_CLIP_H
#define JE_CLIP_H


#ifdef __cplusplus
extern "C" {
#endif

#define JE_CLIP_CENTER 1
#define JE_CLIP_CORNER 0
#include	"basetype.h"
#include	"jetypes.h"

//***************************************************************
// returns true if you need to draw at all.
JETAPI jeBoolean JETCC CalculateClipping(
                           JE_Rect *artRect, int32 *resultX, int32 *resultY, 
                           int32 x, int32 y,
                           const JE_Rect bounds, int32 type);

#ifdef __cplusplus
}
#endif

#endif
