#ifndef _JE_PARSE_H__
#define _JE_PARSE_H__

#include "BaseType.h"
#include "jeTypes.h"
#include "jeParse_cmdtable.h"

#include "jeWorld.h"

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#define JE_PARSE_NAME_LEN				128 // names can be up to 128 characters
#define JE_PARSE_TOKEN_LEN				(JE_PARSE_NAME_LEN+1)
#define JE_PARSE_NUMBER_LEN				11

typedef enum
{
	JE_PARSE_TOKEN_EOF = 256,
	JE_PARSE_TOKEN_STRING,
} JE_PARSE_TOKEN;

typedef struct jeTokenTable_s
{
	char string[JE_PARSE_TOKEN_LEN+1];
	jeBoolean is_newline;
} jeTokenTable;

typedef struct script_user_data
{
	FILE*				shader_file;
	//sh_stage_t			ignored_stage;
	JE_PARSE_TOKEN		lookahead;
	//shader_t*			shader;
	//sh_stage_t			stage;
	jeBoolean			parse_stop;

	jeTokenTable		token;
	int					jet_parse_line_count;
	int					brace_count;
	int					next_line_count;
	int					uninput_cin;
	jeBoolean			uninputted;

	//shader_vars_t		shader_vars;
	jeCommandTable			command_table[];
} scriptData;

typedef struct jeScript_
{
	scriptData			*userdata;
	char				tag[3];
	float				TimeAlpha;

} jeScript;


typedef jeBoolean		(*jeParse_ApproveFunc)(const char* name);
typedef void			(*jeParse_CompileFunc)(scriptData* script);


JETAPI jeBoolean jeScript_Run(char * filename, jeWorld *World);
JETAPI jeBoolean JETCC jeScript_Destroy(jeScript **ptrScript);

JETAPI jeScript * jeScript_Create();
JETAPI jeScript * jeScript_CreateFromFile(char * script);


int				jeParse_Input(scriptData *info);
void			jeParse_InputUnget(int cin, scriptData *info);
int				jeParse_GetInput(scriptData *info);
jeBoolean		jeParse_SetInput(FILE* f, scriptData *info);
void			jeParse_BeginScan(scriptData *info);
void			jeParse_EndScan(scriptData *info);
JE_PARSE_TOKEN	jeParse_Scan(scriptData *info);
jeBoolean		jeParse_Skip(scriptData *info);


#endif