/****************************************************************************************/
/*  PARSE_OUTPUT.C                                                                      */
/*                                                                                      */
/*  Author: Timothy Roff	                                                            */
/*  Description:  Logging funcs for the parser                                          */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was NOT part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/
#include "jeParse_h.h"
#include "jet.h"
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

void jeParse_WriteLog(const char *Msg)
{
	//very damn usefull for finding bugs (in code)		

	va_list		ArgPtr;
    char		TempStr[500];
    char		TempStr2[500];
	FILE		*f;

	va_start (ArgPtr, Msg);
    vsprintf (TempStr, Msg, ArgPtr);
	va_end (ArgPtr);

	f = fopen("JetParse2.log.txt", "wt");

	if (f)
	{
		int32		i, NumErrors;

		NumErrors = jeErrorLog_Count();

		fprintf(f, "Error#:%3i, Code#:%3i, Info: %s\n", NumErrors, 0, TempStr);

		for (i=0; i<NumErrors; i++)
		{
			jeErrorLog_ErrorClassType	Error;
			char						*String;

			if (jeErrorLog_Report(NumErrors-i-1, &Error, &String, &String))
			{
				fprintf(f, "Error#:%3i, Code#:%3i, Info:%s\n", NumErrors-i-1, Error, String);
			}
		}

		fclose(f);
		
	}
	else
	{
		sprintf(TempStr2, "%s\nCould NOT output to log file!", TempStr);
		MessageBox(0, TempStr2, "**ERROR**", MB_OK);
		_exit(1);
	}
	
}
void jeParse_Error(const char * error, ...)
{
	va_list	ArgPtr;
	char	temp[500];

	va_start( ArgPtr, error);
	vsprintf(temp, error, ArgPtr);
	va_end(ArgPtr);

	jeErrorLog_AddString(JE_ERR_PARSE_ERROR, "", temp);

	#ifdef _DEBUG
	//we are in debug so write EVERYTHING from AddStrings to a log file
	jeParse_WriteLog(temp);
	#endif
}

