#ifndef JESHADER_INLINE_
#define JESHADER_INLINE_

#include "jet.h"

JETLINE jeBoolean sh_is_blend_filter(sh_stage_t* s)
{
   return (((s->blend_src == SH_BLEND_ZERO) && (s->blend_dst == SH_BLEND_SRC_COLOR)) ||
           ((s->blend_src == SH_BLEND_DST_COLOR) && (s->blend_dst == SH_BLEND_ZERO)));
}


JETLINE jeBoolean sh_is_blend_blend(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_SRC_ALPHA) &&
           (s->blend_dst == SH_BLEND_ONE_MINUS_SRC_ALPHA));
}


JETLINE jeBoolean sh_is_blend_add(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_ONE) && (s->blend_dst == SH_BLEND_ONE));
}


JETLINE jeBoolean sh_is_blend_src_only(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_ONE) && (s->blend_dst == SH_BLEND_ZERO));
}


JETLINE jeBoolean sh_is_blend_dst_only(sh_stage_t* s)
{
   return ((s->blend_src == SH_BLEND_ZERO) && (s->blend_dst == SH_BLEND_ONE));
}


JETLINE jeBoolean sh_is_opaque_stage(sh_stage_t* s)
{
   return !((s->flags & SH_STAGE_BLENDFUNC) || (s->flags & SH_STAGE_ALPHAFUNC));
}



#endif
