#ifndef JEBMUTIL_H
#define JEBMUTIL_H

#include "jet.h"

#ifndef _INC_WINDOWS
#ifdef STRICT
typedef struct HWND__ * HWND;
typedef struct HBITMAP__ * HBITMAP;
#else // STRICT
typedef void * HWND;
typedef void * HBITMAP;
#endif // STRICT
#endif // _INC_WINDOWS

#ifdef __cplusplus
extern "C" {
#endif

/** helper functions for jeBitmap *****/

/*** Windows HBITMAP conversions : ****/

HBITMAP jeBitmapUtil_CreateHBITMAP(jeBitmap *Bitmap,HWND window,int mip);
	// use DeleteObject when done

jeBitmap * jeBitmapUtil_CreateFromHBITMAP(HWND window,HBITMAP hbm);

/*** Drawing primitives *****/

jeBoolean jeBitmapUtil_SetColor(jeBitmap *Bmp,int R,int G,int B,int A);
	// sets all of the bitmap to one color
	// on palettized, use R=G=B=A= 0 to set all palette indeces to zero

jeBoolean jeBitmapUtil_SmoothBits(jeBitmap_Info *pInfo,void *FmBits,void *ToBits,int radius, jeBoolean wrap);
	// a convolution filter for linear smoothing
	// assembly & fast
	// Fm == To is ok
	// (btw wrap is slow & not in assembly yet)

jeBoolean jeBitmapUtil_SetAlphaFromBrightness(jeBitmap *Bmp);

/*** Misc Utils ***/

jeBitmap * jeBitmapUtil_CreateFromFileName(const jeVFile * BaseFS,const char * BmName);
jeBitmap * jeBitmapUtil_CreateFromFileAndAlphaNames(const jeVFile * BaseFS,const char * BmName,
																	const char *AlphaName);

jeBoolean jeBitmapUtil_SetPaletteFromString(jeBitmap * Bitmap,char ** pParams);
				// moves pParams past the used palette entries

jeBoolean jeBitmapUtil_CompareBitmaps(jeBitmap *bm1,jeBitmap *bm2,char * IntoStr,double * pMSE);
				// compares YUV's

double jeBitmapUtil_MSE2PSNR(double mse);
double jeBitmapUtil_PSNR2MSE(double psnr);

/******

todo :

	WriteToBMP

********/

#ifdef __cplusplus
}
#endif


#endif


