/****************************************************************************************/
/*  MEMORY.C                                                                            */
/*                                                                                      */
/*  Author: Timothy Roff	                                                            */
/*  Description:  Memory stuffs for shaders                                             */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was not part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/

#include "jeShaderDefs.h"
#include "jeShader_h.h"


shader_t* _previous_allocation = NULL;

sh_alloc_func_t JE_SHADER_ALLOC = sh_alloc_static_func;


//=====================================================================================
//	sh_alloc
//=====================================================================================
shader_t* sh_alloc(void)
{
   if (!_previous_allocation) _previous_allocation = JE_SHADER_ALLOC();

   return _previous_allocation;
}



//=====================================================================================
//	jeShader_AllocKeep
//=====================================================================================
void jeShader_AllocKeep(void)
{
   _previous_allocation = NULL;
}

//=====================================================================================
//	she_alloc_set_func
//=====================================================================================
sh_alloc_func_t sh_alloc_set_func(sh_alloc_func_t a)
{
   sh_alloc_func_t o;
   
   o = JE_SHADER_ALLOC;
   JE_SHADER_ALLOC = a;

   return o;
}



shader_t static_shader;


shader_t* sh_alloc_static_func(void)
{
   return &static_shader;
}


//=====================================================================================
//	Array memory manager
//=====================================================================================

int       shader_count;
int       shader_array_size;
shader_t* shaders;


shader_t* sh_alloc_array_func(void)
{
   if (shader_count < shader_array_size) {
      return &shaders[shader_count++];
   }
   else {
	   jeErrorLog_AddString(JE_ERR_SHADER_SCRIPT, "number of shaders exceeds shader_array_size ", (char*)shader_array_size);
       return NULL;
   }
}


shader_t* sh_alloc_set_array(shader_t* array, size_t size)
{
   shader_t* old;

   old               = shaders;
   shaders           = array;
   shader_array_size = size;
   shader_count      = 0;

   return old;
}

//EOF