/****************************************************************************************/
/*  OUTPUT.C                                                                            */
/*                                                                                      */
/*  Author: Timothy Roff	                                                            */
/*  Description:  Shader implementation                                                 */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was not part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/

#include "jeShaderDefs.h"
#include "jeShader_h.h"

#define OUT_OF_RANGE "ERROR 501: out of range!"


const char* sh_waveform_to_string(int w)
{
   switch(w) {
      case SH_WAVE_SIN:
         return "sin";

      case SH_WAVE_TRIANGLE:
         return "triangle";

      case SH_WAVE_SQUARE:
         return "square";

      case SH_WAVE_SAWTOOTH:
         return "sawtooth";

      case SH_WAVE_INVSAWTOOTH:
         return "inverseSawtooth";

      case SH_WAVE_NOISE:
         return "noise";

      default:
         return OUT_OF_RANGE;
   }
}



/* vxmod_to_string:
 ***************************************************************************/
const char* sh_vxmod_to_string(int v)
{
   switch(v) {
      case SH_VXMOD_WAVE:
         return "wave";

      case SH_VXMOD_NORMAL:
         return "normal";

      case SH_VXMOD_BULGE:
         return "bulge";

      case SH_VXMOD_MOVE:
         return "move";

      case SH_VXMOD_AUTOSPRITE:
         return "autosprite";

      case SH_VXMOD_AUTOSPRITE2:
         return "autosprite2";

      case SH_VXMOD_PROJECTION_SHADOW:
         return "projectionShadow";

      case SH_VXMOD_TEXT0:
         return "text0";

      case SH_VXMOD_TEXT1:
         return "text1";

      case SH_VXMOD_STENCIL_SHADOW_EXT:
         return "stencilShadow";

      default:
         return OUT_OF_RANGE;
   }
}



/* cull_to_string
 ***************************************************************************/
const char* sh_cull_to_string(int c)
{
   switch(c) {
      case SH_CULL_FRONT:
         return "front";

      case SH_CULL_BACK:
         return "back";

      case SH_CULL_DISABLE:
         return "disable";

      case SH_CULL_BOTH_EXT:
         return "_both";

      default:
         return OUT_OF_RANGE;
   }
}



/* sort_to_string:
 ***************************************************************************/
const char* sh_sort_to_string(int s, jeBoolean parsable)
{
	char buf[3];

   switch(s) {
      case SH_SORT_PORTAL:
         return "portal";

      case SH_SORT_SKY:
         return "sky";

      case SH_SORT_OPAQUE:
         return "opaque";

      case SH_SORT_DECAL:
         if (parsable) {
            sprintf(buf, "%d", SH_SORT_DECAL);
            return strdup(buf);
         }
         else {
            return "SH_SORT_DECAL";
         }

      case SH_SORT_BANNER:
         return "banner";

      case SH_SORT_SEE_THROUGH:
         if (parsable) {
            sprintf(buf, "%d", SH_SORT_SEE_THROUGH);
            return strdup(buf);
         }
         else {
            return "SH_SORT_SEE_THROUGH";
         }

      case SH_SORT_UNDERWATER: 
         return "underwater";

      case SH_SORT_ADDITIVE:   
         return "additive";

      case SH_SORT_FOG:        
         if (parsable) {
            sprintf(buf, "%d", SH_SORT_FOG);
            return strdup(buf);
         }
         else {
            return "SH_SORT_FOG";
         }

      case SH_SORT_STENCIL_SHADOW:
         if (parsable) {
            sprintf(buf, "%d", SH_SORT_STENCIL_SHADOW);
            return strdup(buf);
         }
         else {
            return "SH_SORT_STENCIL_SHADOW";
         }

      case SH_SORT_NEAREST:
         return "nearest";

      case SH_SORT_NUM_SORTS:
      default:
         if ((s >= 1) && (s <= 16)) {
            sprintf(buf, "%d", s);

            return strdup(buf);
         }
         else {
            return OUT_OF_RANGE;
         }
   }
}



/* blend_to_string:
 ***************************************************************************/
const char* sh_blend_to_string(int b)
{
   switch(b) {
      case SH_BLEND_ONE:
         return "GL_ONE";

      case SH_BLEND_ZERO:
         return "GL_ZERO";

      case SH_BLEND_DST_COLOR:
         return "GL_DST_COLOR";

      case SH_BLEND_ONE_MINUS_DST_COLOR:
         return "GL_ONE_MINUS_DST_COLOR";

      case SH_BLEND_SRC_ALPHA:
         return "GL_SRC_ALPHA";

      case SH_BLEND_ONE_MINUS_SRC_ALPHA:
         return "GL_ONE_MINUS_SRC_ALPHA";

      case SH_BLEND_DST_ALPHA:
         return "GL_DST_ALPHA";

      case SH_BLEND_ONE_MINUS_DST_ALPHA:
         return "GL_ONE_MINUS_DST_ALPHA";

      case SH_BLEND_SRC_COLOR:
         return "GL_SRC_COLOR";

      case SH_BLEND_ONE_MINUS_SRC_COLOR:
         return "GL_ONE_MINUS_SRC_COLOR";

      default:
         return OUT_OF_RANGE;
   }
}



/* alphafunc_to_string:
 ***************************************************************************/
const char* sh_alphafunc_to_string(int a)
{
   switch (a) {
      case SH_ALPHAFUNC_GT0:
         return "GT0";

      case SH_ALPHAFUNC_LT128:
         return "LT128";

      case SH_ALPHAFUNC_GE128:
         return "GE128";

      default:
         return OUT_OF_RANGE;
   }
}



/* depthfunc_to_string:
 ***************************************************************************/
const char* sh_depthfunc_to_string(int d)
{
   switch (d) {
      case SH_DEPTHFUNC_LEQUAL:
         return "lequal";

      case SH_DEPTHFUNC_EQUAL:
         return "equal";

      default:
         return OUT_OF_RANGE;
   }
}



/* rgbagen_to_string:
 ***************************************************************************/
const char* sh_rgbagen_to_string(int g)
{
   switch (g) {
      case SH_RGBAGEN_IDENTITY_LIGHTING:
         return "identityLighting";

      case SH_RGBAGEN_IDENTITY:
         return "identity";

      case SH_RGBAGEN_WAVE:
         return "wave";

      case SH_RGBAGEN_ENTITY:
         return "entity";

      case SH_RGBAGEN_ONE_MINUS_ENTITY:
         return "oneMinusEntity";

      case SH_RGBAGEN_VERTEX:
         return "vertex";

      case SH_RGBAGEN_ONE_MINUS_VERTEX:
         return "oneMinusVertex";

      case SH_RGBAGEN_PORTAL:
         return "portal";

      case SH_RGBAGEN_LIGHTING_DIFFUSE:
         return "lightingDiffuse";

      case SH_RGBAGEN_LIGHTING_SPECULAR:
         return "lightingSpecular";

      case SH_RGBAGEN_ONE_MINUS_PORTAL_EXT:
         return "_oneMinusPortal";

      case SH_RGBAGEN_CONST_EXT:
         return "_const";

      default:
         return OUT_OF_RANGE;
   }
}



/* tcmod_to_string:
 ***************************************************************************/
const char* sh_tcmod_to_string(int t)
{
   switch (t) {
      case SH_TCMOD_ROTATE:
         return "rotate";

      case SH_TCMOD_SCALE:
         return "scale";

      case SH_TCMOD_SCROLL:
         return "scroll";

      case SH_TCMOD_STRETCH:
         return "stretch";

      case SH_TCMOD_TRANSFORM:
         return "transform";

      case SH_TCMOD_TURB:
         return "turb";

      default:
         return OUT_OF_RANGE;
   }
}



/* tcgen_to_string:
 ***************************************************************************/
const char* sh_tcgen_to_string(int t)
{
   switch (t) {
      case SH_TCGEN_BASE:
         return "base";

      case SH_TCGEN_LIGHTMAP:
         return "lightmap";

      case SH_TCGEN_ENVIRONMENT:
         return "environment";

      case SH_TCGEN_VECTOR:
         return "vector";

      case SH_TCGEN_SKY_EXT:
         return "_sky";

      default:
         return OUT_OF_RANGE;
   }
}
