/****************************************************************************************/
/*  SH_RENDER.C                                                                         */
/*                                                                                      */
/*  Author: Timothy Roff	                                                            */
/*  Description:  Takes the info from the world and modifies it                         */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was not part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/

#include "jet.h"
#include "jeShader.h"

jeBoolean jeShader_Render(jeShader *Shader, jeWorld *World, jeEngine *Engine, jeCamera *Camera, jeFrustum *CameraSpaceFrustum)
{
	if(Shader->userdata->shader_vars.proceng.hasProc) //"render" procedural shaders
	{
		int inited;
		inited = Shader->userdata->shader_vars.proceng.initialized;

		if(inited == 0)
		{
			Shader->userdata->shader_vars.proceng.initialized = 1;
			Shader->userdata->shader_vars.proceng.P = Shader->userdata->shader_vars.proceng.Create(NULL, Shader->userdata);

		}
	}

	return JE_TRUE;
}

jeBoolean jeShader_Frame(jeShader *Shader, jeWorld *World, float TimeDelta)
{
	if(Shader->userdata->shader_vars.proceng.hasProc) //animate procedural shaders
	{
		int inited;
		inited = Shader->userdata->shader_vars.proceng.initialized;

		if(inited == 1) //shader has been inited by render so lets animate baby yeah!
		{
			Shader->userdata->shader_vars.proceng.Animate(Shader->userdata->shader_vars.proceng.P, TimeDelta);
		}
	}

	return JE_TRUE;
}