/****************************************************************************************/
/*  SHADER_ACTOR.C                                                                      */
/*                                                                                      */
/*  Author: Timothy Roff	                                                            */
/*  Description:  Shader implementation                                                 */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was not part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/

#include "jeShaderDefs.h"
#include "jeShader_h.h"

//=====================================================================================
//	actorParseFunc
//=====================================================================================
jeBoolean actorParseFunc(int argc, char* argv[], shader_info_t *info)
{
	assert(info != NULL);

	#ifdef _DEBUG
	jeShader_Error("in actorparse");
	#endif

	if (stricmp(argv[1], "$player") == 0)
	{
		sprintf(info->shader_vars.actor_var, "$player"); //sets actor_var to argv[1] AKA $player
	}
	else
	{
		sprintf(info->shader_vars.actor_var, argv[1]); //sets actor_var to argv[1]
	}
	
	return JE_TRUE;
}
	
//=====================================================================================
//	actorBoneParse
//=====================================================================================
jeBoolean actorBoneParse(int argc, char* argv[], shader_info_t *info)
{
	assert(info != NULL);

	#ifdef _DEBUG
	jeShader_Error("in actorboneparse");
	#endif

	jeShader_FatalError(info, "bone is not ready yet. Dont use");
	
	/*for (i = 2; i < argc; i++)
	{
		//set bone attachment code var to argv[i]
		info->shader_vars.bone_var[i] = argv[i];
	}

	info->shader_vars.used_bones = argc;*/

	return JE_TRUE;
		
}

//=====================================================================================
//	actorSectionParse
//=====================================================================================
jeBoolean actorSectionParse(int unused, char* argv[], shader_info_t *info)
{
	jeShader_FatalError(info, "my brain hurts...");

	return JE_TRUE;
}
