/****************************************************************************************/
/*  SHADER_MISC.C                                                                       */
/*                                                                                      */
/*  Author: Timothy Roff	                                                            */
/*  Description:  Shader implementation                                                 */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was not part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/

#include "jeShaderDefs.h"
#include "jeShader_h.h"

typedef enum
{
	PARTICLE_GYSER = 0,
	PARTICLE_SPRAY = 1,
	PARTICLE_SPARKS = 2,
	PARTICLE_RANDOM = 4,
	PARTICLE_BLOOD_GUSH = 8,
	
	PARTICLE_ADVANCED_FIRE = 16,

};

typedef enum
{
	P_ORIGIN_FLOOR = 1,
	P_ORIGIN_CEILING = 2,
	P_ORIGIN_WALL = 3,
	P_ORIGIN_BONE = 4,
	P_ORIGIN_ACTOR_VAR = 5,
};

//=====================================================================================
//	typeParse
//=====================================================================================
jeBoolean typeParse(int unused, char* argv[], shader_info_t *info)
{
	assert(info != NULL);

	#ifdef _DEBUG
	jeShader_Error("in typeparse");
	#endif

	if (stricmp(argv[1], "shader") == 0)
	{
		info->shader_vars.shader_type_flags = (TYPE_SHADER);
		return JE_TRUE;
	}
	
	if (stricmp(argv[1], "mp3script") == 0)
	{
		info->shader_vars.shader_type_flags = (TYPE_MP3SCRIPT);
		return JE_TRUE;
	}

	if (stricmp(argv[1], "mp3+shader") == 0)
	{
		info->shader_vars.shader_type_flags = (TYPE_HYBRID | TYPE_MP3SCRIPT | TYPE_SHADER | TYPE_EXTENSION);
		return JE_TRUE;
	}

	else
	{
		info->shader_vars.shader_type_flags = (TYPE_UNKNOWN | TYPE_EXTENSION);
		jeShader_Error("typeParse: unknown type or extension '%s'", argv[1]);
	}

	return JE_TRUE;
}

//=====================================================================================
//	particleParse (2 min, 14 max)
//=====================================================================================
jeBoolean particleParse(int argc, char* argv[], shader_info_t *info)
{
			
	assert(info != NULL);

	#ifdef _DEBUG
	jeShader_Error("in particle");
	#endif

	if (stricmp(argv[1], "bone") == 0)
	{
		//set origin of system to interal bone var
		info->shader_vars.particle_system.particle_origin = P_ORIGIN_BONE;
		
	}
	else if( stricmp(argv[1], "floor") == 0)
	{
		//set origin to come from a floor
		info->shader_vars.particle_system.particle_origin = P_ORIGIN_FLOOR;
		
	}
	else if( stricmp(argv[1], "ceiling") == 0)
	{
		//like floor but in reverse
		info->shader_vars.particle_system.particle_origin = P_ORIGIN_CEILING;
	}
	else if( stricmp(argv[1], "wall") == 0)
	{
		//no comment
		info->shader_vars.particle_system.particle_origin = P_ORIGIN_WALL;
	}
	else if( stricmp(argv[1], "$actor") == 0)
	{
		//set the origin to come from random places from the actor var
		//this is really cool for making actors and players (remember $actor
		//can equal $player by executing the 'actor $player' command) burst
		//into flames! or a blood gyser muahhaha
		info->shader_vars.particle_system.particle_origin = P_ORIGIN_ACTOR_VAR;
	}
	else
	{
		jeShader_FatalError(info, "arg1 in particle is invalid: %s", argv[1]);
	}

	if (stricmp(argv[2], "gyser") == 0)
	{
		info->shader_vars.particle_system.particle_type = PARTICLE_GYSER;
	}
	else if (stricmp(argv[2], "spray") == 0)
	{
		info->shader_vars.particle_system.particle_type = PARTICLE_SPRAY;
	}
	else if (stricmp(argv[2], "sparks") == 0)
	{
		info->shader_vars.particle_system.particle_type = PARTICLE_SPARKS;
	}
	else if (stricmp(argv[2], "random") == 0)
	{
		info->shader_vars.particle_system.particle_type = PARTICLE_RANDOM;
	}
	else if (stricmp(argv[2], "blood_gush") == 0)
	{
		info->shader_vars.particle_system.particle_type = PARTICLE_BLOOD_GUSH;
	}
	else if (stricmp(argv[2], "adv_fire") == 0)
	{
		info->shader_vars.particle_system.particle_type = PARTICLE_ADVANCED_FIRE;
	}
	else
	{
		jeShader_FatalError(info, "arg2 in particle is invalid: %s", argv[2]);
	}
	
	return JE_TRUE;
}
