/****************************************************************************************/
/*  SHADER_PROCEDURAL.C                                                                 */
/*                                                                                      */
/*  Author: Timothy Roff	                                                            */
/*  Description:  Shader implementation                                                 */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was not part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/

#include "jeShaderDefs.h"
#include "jeShader_h.h"

//procedural list
#include "sh_prc_plasma.h"
//#include "sh_prc_fire.h"
//end procedural list

double chartodouble(const char* text)
{
	double var1;
	var1 = atoi(text);

	return var1;
}

jeBoolean chartojeboolean(const char* text)
{
	if(stricmp(text, "t") == 0)
		return JE_TRUE;
	if(stricmp(text, "T") == 0)
		return JE_TRUE;

	if(stricmp(text, "f") == 0)
		return JE_FALSE;
	if(stricmp(text, "F") == 0)
		return JE_FALSE;
	
	return (JE_TRUE | JE_FALSE); //the procedural should recognize this and cause and error
}


jeBoolean procTexture(int argc, char* argv[], shader_info_t *info)
{
	assert(info != NULL);

	#ifdef _DEBUG
	jeShader_Error("in procedural texture parse");
	#endif

	if (stricmp(argv[1], "plasma") == 0)
	{
		// plasma parms
		//( circle_step, roll_step, do_alpha, do_displacement, use_palette, [palette_spec] )
		//ex: procTexture plasma 0.005 0 f f y trig 128 128 128 255  5.0 1.0 5.0 0.0  0.0 0.5 0.0 0.0
		//or: procTexture plasma 0.01  1 f t n

		//set procedural shader variables
		info->shader_vars.proceng.type_flags = PROC_PLASMA;
		info->shader_vars.proceng.initialized = 0;
		info->shader_vars.proceng.hasProc = JE_TRUE;

		//set "virtual" functions
		info->shader_vars.proceng.Destroy = Plasma_Destroy;
		info->shader_vars.proceng.Create = Plasma_Create;
		info->shader_vars.proceng.Animate = Plasma_Animate;

		//set userdata
		info->shader_vars.proceng.userdata = Plasma_SetUserData(chartodouble(argv[2]), chartodouble(argv[3]), chartojeboolean(argv[4]), chartojeboolean(argv[5]));
		if (stricmp(argv[6], "y") == 0)
		{
			//this is one LONG line of code. it sends parms 7 - 19 to userdata
			//this is used to build the palette if you opted to
			Plasma_SetPSpec(info->shader_vars.proceng.userdata, argv[7], chartodouble(argv[8]), chartodouble(argv[9]), chartodouble(argv[10]), chartodouble(argv[11]), chartodouble(argv[12]), chartodouble(argv[13]), chartodouble(argv[14]), chartodouble(argv[15]), chartodouble(argv[16]), chartodouble(argv[17]), chartodouble(argv[18]), chartodouble(argv[19]));
		}
		
	}
	else if (stricmp(argv[1], "fire") == 0)
	{
		jeShader_Error("Fire procedural is not implemented yet");
	}
	else if(stricmp(argv[1], "water_ripple") == 0)
	{
		jeShader_Error("water_ripple procedutal is not implemented yet");
	}
	else if(stricmp(argv[1], "bumpmap") == 0)
	{
		jeShader_Error("bumpmap procedutal is not implemented yet");
	}
	else if(stricmp(argv[1], "electric") == 0)
	{
		jeShader_Error("electric effects procedutal is not implemented yet");
	}
	else
	{
		jeShader_Error("%s is not a valid procedural_shader", argv[1]);
		return JE_FALSE;
	}

	
	return JE_TRUE;
}