/****************************************************************************************/
/*  JERESOURCE.H                                                                        */
/*                                                                                      */
/*  Author:                                                                             */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
#ifndef	JE_RESOURCE_H
#define JE_RESOURCE_H

#include "BaseType.h"

#ifdef __cplusplus
	extern "C" {
#endif


////////////////////////////////////////////////////////////////////////////////////////
//	jeResourceMgr struct
////////////////////////////////////////////////////////////////////////////////////////
typedef struct jeResourceMgr	jeResourceMgr;




////////////////////////////////////////////////////////////////////////////////////////
//	Resource manager functions
////////////////////////////////////////////////////////////////////////////////////////

//	Create a resource manager.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI jeResourceMgr * jeResource_MgrCreate(
	void );	// no parameters

//	Increment a resource managers ref count.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI int jeResource_MgrIncRefcount(
	jeResourceMgr	*ResourceMgr );	// manager whose ref count will be incremented

//	Destroy a resource manager.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI void jeResource_MgrDestroy(
	jeResourceMgr	**DeadResourceMgr );	// manager to zap




////////////////////////////////////////////////////////////////////////////////////////
//	Generic resource functions
////////////////////////////////////////////////////////////////////////////////////////

//	Add a new resource.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI jeBoolean jeResource_Add(
	jeResourceMgr	*ResourceMgr,	// resource manager to add it to
	char			*Name,			// name
	void			*Data );		// data

//	Get an existing resource.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI void * jeResource_Get(
	jeResourceMgr	*ResourceMgr,	// resource manager to get it from
	char			*Name );		// resource name

//	Delete an existing resource.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI int jeResource_Delete(
	jeResourceMgr	*ResourceMgr,	// resource manager to delete it from
	char			*Name );		// resource name




////////////////////////////////////////////////////////////////////////////////////////
//	VFile specific resource functions
////////////////////////////////////////////////////////////////////////////////////////

//	Add a new VFile resource.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI jeBoolean jeResource_AddVFile(
	jeResourceMgr	*ResourceMgr,	// resource list to add it to
	char			*Name,			// name
	jeVFile			*Data );		// data

//	Get an existing VFile resource.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI jeVFile * jeResource_GetVFile(
	jeResourceMgr	*ResourceMgr,	// resource list to get it from
	char			*Name );		// name

//	Delete an existing VFile resource.
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI int jeResource_DeleteVFile(
	jeResourceMgr	*ResourceMgr,	// resource list to delete it from
	char			*Name );		// name

// [MLB-ICE]
////////////////////////////////////////////////////////////////////////////////////////
//
//  Open a vfile(directory) for Resource Manager (WITH AutoRemove on ResMgrDestroy)
//  DirName = Path of directory
//  ResName = Alias of this resource
//     by Icestorm
//
////////////////////////////////////////////////////////////////////////////////////////
JETAPI jeBoolean JETCC jeResource_OpenDirectory(jeResourceMgr* pResourceMgr, char* DirName, char* ResName);
// [MLB-ICE] EOB

//	Create a Resource Manager using the default paths.
//     by Incarnadine modified by Icestorm [Added autoremove]
////////////////////////////////////////////////////////////////////////////////////////
JETAPI jeResourceMgr* JETCC jeResource_MgrCreateDefault(void);
#ifdef __cplusplus
	}
#endif

#endif
