/****************************************************************************************/
/*  JESCRIPT.C                                                                          */
/*                                                                                      */
/*  Author: Timothy Roff (CyRiuS)                                                       */
/*  Description:  Script Implementation                                                 */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  This file was NOT part of the original Jet3D, released December 12, 1999.           */
/*                                                                                      */
/****************************************************************************************/

#include "jeScriptDefs.h"
#include "jeScript.h"
#include "jeChain.h"
#include "Errorlog.h"
#include "jeAssert.h"

JETAPI jeBoolean jeWorld_AddScript(jeWorld *World, jeScript *Script);

JETAPI jeBoolean JETCC jeScript_Destroy(jeScript **ptrScript)
{
	//destroys a script
	jeScript	* script;

	assert(ptrScript != NULL);

	script = *ptrScript;

	if ( script ) //check 1
	{
		//jeRam_Free(script->userdata); //the user data has RAM alloced to it, so free it first
		jeRam_Free(script); //free it

		return JE_TRUE;

	}

	return JE_FALSE;
}
JETAPI jeScript * jeScript_Create()
{
	//create a script
	jeScript	*script;

	// Init,
	script = NULL;

	//warning C4700: local variable 'script' used without having been initialized
	//this error will go away soooooon

	return(script);

}

JETAPI jeScript * jeScript_CreateFromFile(char * script)
{
	FILE*		file;
	jeScript	*newScript;

	assert(script != NULL);

	file = fopen(script, "r");

	if (!file)
	{
		jeErrorLog_AddString(JE_ERR_SUBSYSTEM_FAILURE, "jeScript_CreateFromFile: could not open the script file! ", script);
		return JE_FALSE;
	}

	newScript = jeScript_Create();
	
	return(newScript);
}


JETAPI jeBoolean jeScript_Run(char * filename, jeWorld *World)
{
	FILE* f;
	jeScript	*my_script;
		
	//assert(script != NULL); //some checking
	// Commented out by Incarnadine -- please compile before commiting to the CVS!

	
	f = fopen(filename, "r"); //open the script for reading

	if (!f)
	{
		jeErrorLog_AddString(JE_ERR_SUBSYSTEM_FAILURE, "jeScript_Run: could not open the script file! ", filename);
		return JE_FALSE;
	}

	//create the file
	my_script = jeScript_Create();

	//set the script file
	
	//everything is good so parse the script
	
	//TODO: Well what do YOU think!!!!!

	// The script was parsed successfully
	// so add it to the world chain
	
	jeWorld_AddScript(World, my_script);

	return JE_TRUE;
}



//======================================
// jeScript_Render
// Preforms the actions of the script
//======================================
jeBoolean jeScript_Render(jeScript *Script, jeWorld *World, jeEngine *Engine, jeCamera *Camera, jeFrustum *CameraSpaceFrustum)
{
	//TODO: perform actions of script

	return JE_TRUE;
}


//======================================
// jeScript_Frame
// Update all the info
//======================================
jeBoolean jeScript_Frame(jeScript *Script, jeWorld *World, float TimeDelta)
{
	//TODO: read info from script and update objects info

	return JE_TRUE;
}