#define		SAFE_DELETE(p)  { if(p) { delete (p);     (p)=NULL; } }
#define		SAFE_RELEASE(p) { if(p) { (p)->Release(); (p)=NULL; } }

#define		SET_POINT(point, x, y) point.x = x; point.y = y
#define		SET_RECT(rect, x, y, cx, cy) rect.left = x; rect.top = y; rect.right = cx; rect.bottom = cy
#define		LIMIT(val, l, h) val = val < l ? l : val > h ? h : val
#define		SWAP(a,b) (a^=b^=a^=b)
#define		SWAP32(a,b) asm{push eax;mov eax,b;xor a,eax;mov eax,a;xor b,eax;mov eax,b;xor a,eax;pop eax}
#define		SWAP16(a,b) asm{push ax;mov ax,b;xor a,ax;mov ax,a;xor b,ax;mov ax,b;xor a,ax;pop ax}

/*template <typename type>
void	LIMIT(type& val, long min, long max) {
		val = val < min ? min : val > max ? max : val;
}*/


#define		M_RGB24(R, G, B)	( ((UINT)R<<16) | ((UINT)G<<8) | ((UINT)B) )
#define		M_RGB16(R, G, B)	( ((UINT)((R>>3)<<10) + (UINT)((G>>3)<<5) + (UINT)(B>>3)) )
#define		M_RGB16_565(R, G, B)	( ((UINT)((R>>3)<<11) + (UINT)((G>>2)<<5) + (UINT)(B>>3)) )
