#define	MAX_ETC_STR_LEN	15
#define	MAP_MAX_STRLEN	23

class CGameMain;
class CChr;
class CGraphic;
class CSoundMng;
class CControl;
class CViewMap;
class CMapChip;
class CSwitch;

typedef struct _DIRECTXUSE
{
	bool	m_bDirectDrawUse;
	BYTE	m_byDDMemoryFlags;//DDMF_LOCAL, NONLOCAL, VIDEO, SYSTEM
	bool	m_bDirectSoundUse;
	bool	m_bFullScreen;
	bool	m_bMouseUse;
	bool	m_bKeyBoardUse;
	bool	m_bJoyUse;
	bool	m_bChangeDisplay;
} DIRECTXUSE, *LPDIRECTXUSE;

typedef struct _FILENAME
{
	bool	m_bStartLoading;//۽ ӵͷε
	LPSTR	m_lpPath;
	LPSTR	m_lpMap;
	LPSTR	m_lpMapChip;
	LPSTR	m_lpEvent;
	LPSTR	m_lpGraphic;
	LPSTR	m_lpETC;
	LPSTR	m_lpAni;
} FILENAME, *LPFILENAME;

typedef struct _MAXSPRITECOUNT
{
	WORD	wMapChip;
	WORD	wChara;
	WORD	wEffect;
} MAXSPRITECOUNT, *LPMAXSPRITECOUNT;

typedef struct _MAXGROUPSPRITECOUNT
{
	BYTE	byMapChip;
	BYTE	byChara;
	BYTE	byEffect;
} MAXGROUPSPRITECOUNT, *LPMAXGROUPSPRITECOUNT;

//{	Grahphic Table
	typedef struct _EFFECTTABLE
	{
		WORD	wAlpha1[32][65536>>EFFECT_QUALITY];
		WORD	wAlpha2[32][65536>>EFFECT_QUALITY];
		WORD	wGamma[32][65536>>EFFECT_QUALITY];
		WORD	wGray[65536>>EFFECT_QUALITY];
	} EFFECTTABLE, *LPEFFECTTABLE;
//}	Grahphic Table


typedef struct _ENGINE
{
	//Option
	WORD	m_wFrameCount;	// ʴ Ӽ
	bool	m_bFrameSkip;	//뿩
	bool	m_bFrameDelay;	//뿩
	bool	m_bNetWorkUse;	//뿩

	//Info
	HWND	m_hWnd;			// ڵ
	LPSTR	m_lpAppName;	//ø̼ 
	HDC		m_hDC;			//HDC
	int		m_iX;
	int		m_iY;
	RECT	m_rctScreen;	//ũ 簢 ũ
	RECT	m_rctView;		//̴ 簢 ũ
	POINT	m_flipAddPos;
	int		m_iWidth;
	int		m_iHeight;
	BYTE	m_byColorBits;	//8, 16, 24, 32

	//Value Range Setting
	POINT	m_MapChipSize;	//Ĩ( x,y ؾ)
	BYTE	m_byMaxSoundBuf;
	int		m_iMaxSprite;
	int		m_iMaxBackSurfaceCount;
	int		m_iCurrentBackSurfaceCount;
	int		m_iMaxRunCase;
	int		m_iMaxEvent;
	int		m_iMaxEventPage;
	int		m_iMaxEventScript;
	BYTE	m_byMaxAniMChip;
	int		m_iMaxAnimation;
	int		m_iMaxAniCmd;
	int		m_iMaxSwitch;
	int		m_iMaxVariable;

	//Map
	int		m_iMaxMap;
	int		m_iMaxMChip;
	BYTE	m_byUseMap;
	BYTE	m_byMapIndex[MAX_VIEWMAP_COUNT];//MF_NONE, MF_2DRPG, MF_2DSML, MF_2DACT, MF_3DRPG, MF_3DSML, MF_3DACT
	bool	m_bMovePixelType;

	//BackSurface
	DWORD	m_dwColorKey;
	DWORD	m_dwBackColor;

	FILENAME	FileName;
	DIRECTXUSE	DirectXUse;
	MAXSPRITECOUNT		MaxSpriteCnt;
	MAXGROUPSPRITECOUNT	MaxGroupSpriteCnt;//ѱ׷ Ʈ ִ밹
} ENGINE, *LPENGINE;

typedef struct _GAMEMAIN {
	CChr	*pMainChr;
	int		iMainChrID;
	int		nFrame;
	int		nSecFrame;
	int		iTick;
	int		iOrgTick;
	int		iDelay;
	int		iSkipCount;
	bool	bSkip;
	bool	bDelay;
	DWORD	dwCurrentTime;
	DWORD	dwOldTime;
} GAMEMAIN, *LPGAMEMAIN;

typedef struct _ETCSETUP {
	BYTE	byMapChipGroupCnt;
	BYTE	byCharaGroupCnt;
	BYTE	byEffectGroupCnt;
	BYTE	byMapSize;

	LPSTR	lpMapChipGroupName;//Ĩ ׷̸
	LPSTR	lpCharaGroupName;//Ʈĳ ׷̸
	LPSTR	lpEffectGroupName;//Ʈ ׷̸
	char	lpMoney[MAX_ETC_STR_LEN];//ݾ 
	bool	bScript;//̺Ʈ ũƮ  Ұΰ
	bool	*pbColorKeyUse;
	WORD	wFrameCount;
} ETCSETUP, *LPETCSETUP;

typedef struct _GAMEDATA {
	CGraphic		*m_pSprite;
	CGraphic		*m_pSurface;
	CGraphic		*m_pAnima;
	CSoundMng		*m_pBGM;
	CSoundMng		*m_pSE;
	CControl		*m_pCtr;
	CViewMap		*m_pMap[MAX_VIEWMAP_COUNT];
	CMapChip		*m_pMChip;
	CSwitch			*m_pSwitch;
	CChr			*m_pChr[MAX_CHARA];
	CGameMain		*m_pGameMain;
	ETCSETUP		etc;
	EFFECTTABLE		eftTable;
} GAMEDATA, *LPGAMEDATA;

typedef struct _DDRAWOPTION {
	bool			fMirrorW;
	bool			fMirrorH;
} DDRAWOPTION, *LPDDRAWOPTION;

//{ Image, Graphic
	typedef struct _IMAGEDATA {
		HANDLE				szData;
		LPBITMAPINFO		lpbmpInfo;
		LPBITMAPINFOHEADER	lpbmpheader;
		LPRGBQUAD			m_pRGBTable;
		LPBYTE				m_lpData;
		LPBYTE				m_lpOrgData;
		int					m_iW;
		int					m_iH;
		DWORD				m_dwSize;
	} IMAGEDATA, *LPIMAGEDATA;

	typedef struct _GRAPHIC
	{
		POINT			m_scrPos;
		HANDLE			szbmpInfo;
		HANDLE			szlpData;
		HANDLE			szSrcData;
		LPBITMAPINFO	lpbmpInfo;
		int				m_iW;
		int				m_iH;
		DWORD			m_dwSize;
		LPBYTE			m_lpData;
	} GRAPHIC, *LPGRAPHIC;

	typedef struct _GRAPHICDATA {
		DWORD	dwImgSize;
		int		iW;
		int		iH;
		LPBYTE	lpImgData;
	} GRAPHICDATA, *LPGRAPHICDATA;
//} Image, Graphic


//	{	animation...
typedef union _ANIEFFECTPOS
{
	struct {
		short		sX;
		short		sY;
	};
	struct {
		short		sAddX;
		short		sAddY;
		short		sCenterX;
		short		sCenterY;
	};
} ANIEFFECTPOS, *LPANIEFFECTPOS;

typedef struct _ANIEFFECT
{
	BYTE		byIndex[2];
	WORD		wEft;
} ANIEFFECT, *LPANIEFFECT;

typedef union _ANICMDOBJ {
	struct {
		BYTE	byValue[5];
	};
	struct {
		short	sValue[1];
		BYTE	byValue[3];
	};
	struct {
		short	sValue[2];
		BYTE	byValue[1];
	};
} ANICMDOBJ, *LPANICMDOBJ;

typedef struct _ANICMD
{
	BYTE		byIndex[2];
	ANICMDOBJ	cmdData;
} ANICMD, *LPANICMD;

typedef struct _ANICMDLIST
{
	ANIEFFECT	effect[MAX_ANIMA_EFFECT_COUNT];
	BYTE		byImage;
	BYTE		bySpeed;
	WORD		wCmdCnt;
	LPANICMD	lpAniCmd;
} ANICMDLIST, *LPANICMDLIST;

typedef struct _ANIMATION
{
	WORD			wAniCnt;
	LPANICMDLIST	lpCmdList;
} ANIMATION, *LPANIMATION;
//	}	animation...


//	{	map...
typedef struct _MAPCHIPDATA {
	WORD		mapCnt[MAX_MAP_LAYER_COUNT];//Ĩ ȣ
	WORD		eventCnt;//̺Ʈ ȣ
} MAPCHIPDATA, *LPMAPCHIPDATA;

typedef struct _MAP {
	int				iPrtID;
	BYTE			byW;
	BYTE			byH;
	char			mapName[MAP_MAX_STRLEN];
	BYTE			byBGM;
	BYTE			indexBGM;
	BYTE			byTeleport;
	BYTE			bySave;
	BYTE			byEscape;
	BYTE			byScrLoop;
	int				iMapGra;
	LPMAPCHIPDATA	lpMap;//Ĩϳ Ͱ   struct
} MAP, *LPMAP;

typedef struct _ALLMAP {
	int				iMapCnt;//ʰ
	LPMAP			lpMap;//ʵ
} ALLMAP, *LPALLMAP;
//	}	map...


//	{	mapchip...
typedef struct _ANIMAPCHIP
{
} ANIMAPCHIP, *LPANIMAPCHIP;

typedef struct _MCHIPPROPERTY
{
	BYTE			byTile;// 
	BYTE			byPass;// 
	BYTE			byDPass;// 
} MCHIPPROPERTY, *LPMCHIPPROPERTY;

typedef struct _MAPCHIP
{
	char			tile[20][15];//Ĩٴ ̸ - ַ  ϱ ̸
	LPMCHIPPROPERTY lpMChip;//ĨӼ
	LPANIMAPCHIP	lpAniMChip;//ִϸ̼ǸĨ
} MAPCHIP, *LPMAPCHIP;
//	}	mapchip...

//	{	gamemap...
typedef struct _VIEWMAP {
	int		iMap;
	int		iSurface;
	int		iMainChrID;
	RECT	rctView;
	POINT	scrPos;
	POINT	halfViewSize;
	POINT	mapSize;
} VIEWMAP, *LPVIEWMAP;
//	{	gamemap...



//̺Ʈ ü...
//	{	...
typedef struct _EVENTHEADER
{
	WORD			wEventMaxCount;
	WORD			wEvPageMaxCount;
	WORD			wEventCount;
} EVENTHEADER, *LPEVENTHEADER;

typedef struct _EVENTPAGEHEADER
{
	WORD			wRunCaseCnt;
	WORD			wScriptCnt;
	BYTE			byEvIDSize;
} EVENTPAGEHEADER, *LPEVENTPAGEHEADER;
//	}	...

//	{	 ...
typedef struct _MOVEWAY
{
} MOVEWAY, *LPMOVEWAY;
//	}	 

//	{	̺Ʈ Ŀ...
typedef union _EVENTCMDS {
	struct {
		BYTE			byMsgSize;
		LPSTR			lpMsg;
	};

	struct {
		BYTE			byPos;
		bool			bWindowStyle;
		bool			bWait;
	};
} EVENTCMDS, *LPEVENTCMDS;
//	}	̺Ʈ Ŀ...


//	{	̺ƮŸ
typedef union _RUNCASEOBJ {
	struct {	//RUNCASENORMAL
		int		iCnt;//ȣ
		bool	bValue;
	};

	struct {	//_RUNCASEVARIABLE
		int		iVar;
		int		iMin;//
		int		iMax;//
	};

	struct {	//_RUNCASEMONEY
		int		iMoney;
		int		iMax;
	};

	struct {	//_RUNCASETIMER
		int		iVar;
		int		iMin;//
		int		iSec;//
	};
} RUNCASEOBJ, *LPRUNCASEOBJ;

typedef struct _RUNCASE
{
	BYTE			byIndex;
	RUNCASEOBJ		caseObj;			//LPVOID ͸ Ʈķ ȯϿ.. ..
} RUNCASE, *LPRUNCASE;

typedef struct _EVENTSETUP
{
//{ ̹ 
	int				iImg;
	bool			bImgAlpha;
//} ̹ 

//{ ̺Ʈ 
	BYTE			byEvRunCase;
	BYTE			byRunRank;
	int				iAnimation;
//} ̺Ʈ 

//{ ̵ 
	BYTE			byMoveType;
	BYTE			byMoveSpeed;
	bool			bMoveDash;
	MOVEWAY			moveWay;
//} ̵ 

//{ ϸ̼ Ÿ
//} ϸ̼ Ÿ
} EVENTSETUP, *LPEVENTSETUP;

typedef struct _SCRIPT
{
	BYTE			byIndex;
	EVENTCMDS		evCmdData;			//LPVOID ͸ ̺Ʈ Ŀǵ Ʈķ ȯϿ.. ..
} SCRIPT, *LPSCRIPT;

typedef struct _SCRIPTFUNCDATA
{
	char			funcName[256];
	char			funcCmd[256];
	int				index;
	int				iErr;
} SCRIPTFUNCDATA, *LPSCRIPTFUNCDATA;

typedef struct _EVENTPAGE
{
	EVENTPAGEHEADER	evHeader;

	EVENTSETUP		eventSetup;
	LPRUNCASE		lpRunCase;
	EVENTSETUP		evSetup;
	LPSCRIPT		lpScript;

	LPSTR			lpEvID;
} EVENTPAGE, *LPEVENTPAGE;

typedef struct _EVENTOBJECT
{
	BYTE			lpEvPageCnt;

	LPEVENTPAGE		lpEvPage;
} EVENTOBJECT, *LPEVENTOBJECT;
//	}	̺ƮŸ


typedef struct _EVENT
{
	EVENTHEADER		evHeader;
	LPEVENTOBJECT	lpEvent;
} EVENT, *LPEVENT;



//{ chr
typedef struct _CHRMESSAGE {
	bool		bRun;
	BYTE		byIndex[2];
	ANICMDOBJ	cmd;
} CHRMESSAGE, *LPCHRMESSAGE;

typedef struct _CHR {
	int			iChrID;
	int			iAni;//ϸ̼
	bool		bAniEnd;
	bool		bEftAniEnd;
	int			bStop;
	BYTE		byDirection;//
	WORD		wAddSpriteCnt;
	BYTE		byImgIndex[2];
	BYTE		byImage;
	bool		bDraw;
	bool		bCompute;
	POINT		pos;
	LPPOINT		lpDrawPos;
	BYTE		byCtr;//Ʈ (CTR_PLAYER, CTR_PLAYER2, CTR_NETWORK, CTR_EVENT, CTR_ENEMY)
	BYTE		byDrawStyle;
	BYTE		byEftLevel;
	BYTE		byRuningEftCnt;
	CHRMESSAGE	chrmsg;
} CHR, *LPCHR;
//} chr

typedef struct _EFFECTDATA {
	int			iPrtChr;
	POINT		addPos;
	POINT		centerAddPos;
	LPPOINT		lpPrtPos;
	bool		bPosType;
	bool		bMoveType;
} EFFECTDATA, *LPEFFECTDATA;



typedef struct _RGB
{
	BYTE r;
	BYTE g;
	BYTE b;

	void	SetRGB		(BYTE er, BYTE eg, BYTE eb){r = er, g = eg, b = eb;}
//	short	Convert15	() { return (short) (((r&248)<<7) + ((g&248)<<2) + (b>>3)); }
//	short	Convert16	() { return (short) (((r&248)<<8) + ((g&252)<<2) + (b>>3)); }
} RGB, *LPRGB;

