// GameEngine.h: interface for the CGameEngine class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GAMEENGINE_H__25BABC0A_615B_11D4_ABAF_00104B15DFC2__INCLUDED_)
#define AFX_GAMEENGINE_H__25BABC0A_615B_11D4_ABAF_00104B15DFC2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "EngineDefine.h"
#include "macro.h"
#include "asm.h"
#include "structs.h"

class CLLECompressed;
class CGameData;
class CGameEngine  
{
public:
	CGameEngine();
	virtual ~CGameEngine();

protected:
	LPENGINE		m_pEng;
	CGameData		*m_pGameData;
	int				m_iCurrentBackSurface;

protected:
	virtual	CLLECompressed*	GetLLE(int iSpr) { return NULL; };
	virtual	LPVOID			GetDirectDraw() { return NULL; };
	virtual	void			SetBufferUnLock() {};
	virtual	void			UpdateData(LPVOID lpdata) {};
	virtual	HDC				GetSurfaceDC(int iImg = 0) { return NULL; };
	virtual	void			ReleaseSurfaceDC(HDC hdc) {};
	virtual	long			GetPitch() { return 0; };
	virtual	long			GetConvertPitch() { return 0; };
	virtual void			DDBlt(LPRECT lprect1, LPRECT lprect2, LPVOID lpSurface, int iSpr, LPDDRAWOPTION lpddop = NULL) { return; };
	virtual void			DDBltFast(POINT pos, LPVOID lpSurface, POINT destSize, int iSpr) { return; };

public:
	void					Release();
	bool					CreateEngine(LPENGINE lpEng = NULL, HWND hWnd = NULL);
	virtual	LRESULT			CreateSurface(int w, int h, DWORD dwColorKey, int iCnt);
	LRESULT					AddBackSurface(int w, int h, DWORD dwColorKey);
	int						GetCurrentBackSurface();
	WORD					GetFirstSurfaceNULL();
	bool					IsBackSurface(int iSur);
	LRESULT					SetBackSurfaceSize(int w, int h, DWORD dwColorKey, int iSur);
	POINT					GetBackSurfaceSize(int iSur);
	virtual	LRESULT			AddSprite(int w, int h, LPBYTE lpData, int *iSpr = NULL, bool bAddCnt = true);
	virtual	void			DeleteSprite(int iSpr, bool bAddCnt = true);
	void					DeleteSurface(int iSur);
	void					DeleteCurrentSurface();
	void					DeleteAllSprite();
	void					DeleteAllSurface();

	LPENGINE				GetGameEngineData() { return m_pEng; };
	LPGAMEDATA				GetGameData();
	bool					IsGameData();
	CGameData				*GetGameDataClass() { return m_pGameData; };
	void					SetGameData(LPGAMEDATA lpGameData);

	bool 					OpenFileGameData(LPSTR lpPath);
	bool					SaveFileGameData(LPSTR lpPath);
	FILE* 					OpenMyFile(FILE *pFile, LPSTR lpPath, LPSTR lpFileName, LPSTR lpRtnName, bool bRead = true);
	FILE* 					OpenMyFile_Name(FILE *pFile, LPSTR lpFileName, bool bRead = true);
	bool					ReadFileData(FILE *pFile, LPVOID lpBuffer, DWORD dwSize, DWORD dwCount, LPSTR lpFileName);
	bool					WriteFileData(FILE *pFile, LPVOID lpBuffer, DWORD dwSize, DWORD dwCount, LPSTR lpFileName);

	void					UpdateDatas(LPENGINE lpEng, CGameData *pGameData);
	HRESULT					FailedMessageBox(HRESULT hresult, LPSTR lpmsg, LPSTR lpTitle);

	//GameMain
	LRESULT					GameProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	bool					GameProcMFC(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, HDC hDC);
	virtual void			UpdateFrame(HDC hDC, LPGAMEMAIN lpGame = NULL);
	virtual bool			CheckFrameSkip(LPGAMEMAIN lpGame);
	virtual void			SetFrameCount(LPGAMEMAIN lpGame, WORD wFrameCount);
	virtual void			SetFrameCount(WORD wFrameCount);
	
	//Key
	void					InitKeyBuffer();
	void					SetKeyDown(BYTE byVKeyIndex);//PARAM = VK_...
	void					SetKeyUp(BYTE byVKeyIndex);//PARAM = VK_...
	LPBYTE					GetKeyBuffer();


	//Map
	virtual bool			CreateMap(int w, int h, LPMAP lpMap = NULL, int *iMap = NULL);
	virtual void			SetMapLayer(BYTE byLayer);
	virtual bool			SetMapData(LPMAP lpMap, int iMap);
	virtual bool 			SetMapChipData(POINT pos, LPMAPCHIPDATA lpMapChip, int iMap);
	virtual bool 			SetMapChipData(POINT pos, int *iMapCnt, int *iEventCnt, int iMap);
	virtual void 			SetMapPrtID(int iMap, int iPrtID);
	virtual LPMAP			GetMapData(int iMap);
	virtual LPMAPCHIPDATA	GetMapChipData(POINT pos, int iMap);
	virtual int				GetMapCount();
	virtual POINT			GetMapSize(int iMap);
	virtual void			DeleteMapData(int iMap);
	virtual void			DeleteMapDataAllChild(int iPrt);

	//ViewMap
	virtual void			DrawMap();
	void					DrawMap(int iMap, int iSurface = 0);
	virtual void			SetHalfViewPos(int x, int y);
	virtual void			SetMapPosition(POINT pos, bool bUpdateMap = false);
	virtual void			SetMapMainChrPointer(int iMainChrID);
	virtual POINT			GetMapScrollPos();
	virtual int				GetViewMap();
	virtual int				GetDrawMapSurface();

	//MapChip
	virtual LPSTR			GetTileIndexName();
	virtual LPSTR			GetTileIndexName(int index);
	virtual LPMCHIPPROPERTY GetMapChipProperty(int iMChip);
	virtual void			SetTileIndexName(LPSTR lpName, int index);
	virtual void			SetMapChipProperty(LPMCHIPPROPERTY lpMChip, int iMChip);
	virtual void			SetMapChipProperty(BYTE *byTile, BYTE *byPass, BYTE *byDPass, int iMChip);

	//Animation
	virtual void			ReleaseAnimation();
	virtual void			AddAniCommend(int iAni, LPANICMD lpAni);
	virtual void			SetAniCommend(int iAni, LPANICMD lpAni, int iCmd);
	virtual void			InsertAniCommend(int iAni, LPANICMD lpAni, int iCmd);
	virtual	void			DeleteAniCommend(int iAni, int iCmd);
	virtual LPANICMDLIST	GetAniCommend(int iAni);
	virtual void			SetAniImage(int iAni, BYTE byImg);
	virtual void			SetAniSpeed(int iAni, BYTE wSpd);
	virtual	BYTE			GetAniImage(int iAni);
	virtual BYTE			GetAniSpeed(int iAni);
	virtual	int				GetAniCmdCount(int iAni);
	virtual LPANIMATION		GetAnimateData();
	virtual void			SetEffect(int iAni, int iEft, LPANIEFFECT lpEffect);
	virtual LPANIEFFECT		GetEffect(int iAni, int iEft);

	//Switch, Variable
	virtual void			SetSwitchName(int iSw, LPSTR lpName);
	virtual void			SetSwitch(int iSw, bool bValue);
	virtual LPSTR			GetSwitchName(int iSw);
	virtual bool			GetSwitch(int iSw);
	virtual void			SetVariableName(int ivar, LPSTR lpName);
	virtual void			SetVariable(int ivar, int iValue);
	virtual LPSTR			GetVariableName(int ivar);
	virtual int				GetVariable(int ivar);

	//Chara
	LPCHR					GetChrData(int iChr);
	void					AddChr(BYTE byChrIndex, LPCHR lpChr);//byChrIndex = CHR_MAIN, CHR_EXTRA, CHR_ENEMY
	void					DestroyChara(WORD wChr);// ĳ ȣ
	void					InitChrAnimate(WORD wChr);
	bool					PlayChrAnimate(WORD wChr, int iAni);
	void					SetChrCheckFrame(int wChr, bool bDraw = true, bool bCompute = true);
	int						GetAddSpriteNumber(BYTE byImgIndex[]);//byImgIndex[0] = SI_MAPCHIP, SI_SPRITE, SI_EFFECT
	void					SetChrGraphicIndex(WORD wChr, BYTE byImgIndex[]);
	void					GetChrGraphicIndex(WORD wChr, BYTE *bypImgIndex);
	bool					IsChrAnimateEnd(WORD wChr);
	bool					IsChr(WORD wChr);
	void					SetChrAnimateRewind(WORD wChr);
	void					SetChrAnimateRepeat(WORD wChr, bool bRepeat);
	void					SetChrPosition(WORD wChr, POINT pos);
	void					SetChrSpeed(WORD wChr, BYTE bySpd);
	int						GetMainChrID();
	CChr*					GetMainChrObj();
	CChr*					GetChrObj(int iChr);
	void					SetMainChr(int iChr);

	//Graphic
	LPEFFECTTABLE	GetEffectTable();
	long			GetSurfacePitch(int iImg);
	long			GetSpritePitch(int iImg);
	LPBYTE			GetSpriteBuffer(int iSpr);
	void			GetSpriteRectBuffer(LPBYTE lpDest, RECT rect, int iSpr);
	POINT			GetSpriteSize(int iSpr);
	virtual	int		GetCurrentSprite();
	virtual	int		GetSpriteCount();
	int				GetSpriteBufSize(int iSpr);
	void			GetSpriteGraphic(LPGRAPHIC lpGra, int iSpr);
	LPGRAPHIC		GetSpriteGraphic(int iSpr);
	void			SetSpriteBuffer(int iSpr, LPBYTE lpBuf);
	void			SetSpriteGraphic(LPGRAPHIC lpGra, int iSpr);
	virtual void	SetChangeSprite(int iSpr1, int iSpr2);
	void			SetSpriteChangeColor(RGB destRgb, RGB srcRgb, int iSpr);
	void			SetUpdateFrame(bool bUpdate);


	virtual	bool	CheckDirectDraw();
	virtual	bool	CheckRGB565();
	LPBYTE			GetSurfaceBuffer(int iSur);
	void			GetSurfaceRectBuffer(LPBYTE lpDest, RECT rect, int iSur);
	LPGRAPHIC		GetSurfaceGraphic(int iSur);
	HDC				GetDDSurfaceDC(int iImg = 0);
	void			ReleaseDDSurfaceDC(HDC hdc);

	bool 			SetToggleFullScreen();
	bool			SetFullScreen();
	HRESULT			CreateDDSurface();
	virtual	bool	ReleaseDDraw();
	virtual	bool	ReleaseDDSuface();
	virtual	void	ClearSurface(int iImg = 0);
	virtual	void	FillSprite(DWORD color, int iImg = 0);
	void			EffectBlt(POINT pos, int iSur, LPGRAPHIC lpGraSrc, BYTE byFadeLevel, BYTE byEffectFlag = 0);//EBF_ALPHA 
	void			EffectBlt(POINT pos, int iImg[2], BYTE byFadeLevel, BYTE byEffectFlag = 0);//EBF_ALPHA 
#ifdef VERSION_FULL
	void			EffectBltZoomIn(POINT pos, int iImg[2], BYTE byFadeLevel, float fzoom, BYTE byEffectFlag = 0);//EBF_ALPHA
#endif
	virtual	void	CopySurface(int iDest, int iSrc);
	virtual	bool	BltZoom(POINT pos, float fzoom, int iSpr, int iSurface = 0);
	bool			BltZoomIn(POINT pos, LPRECT lpBltRect, float fzoom, int iSpr, int iSurface = 0);
	bool			CopySurfaceToSprite(int iSpr, int iSurface = 0);
	bool			BltZoomOut(POINT pos, LPGRAPHIC lpGraSrc, BYTE byzoom, int iSurface = 0);
	bool			BltZoomOut(POINT pos, BYTE byzoom, int iSpr, int iSurface = 0);
	bool			BltZoomOutSurface(POINT pos, BYTE byzoom, int iSrcSurface, int iDestSurface = 0);
	void			Blt(POINT pos, int iSpr, int iSurface = 0);
	void			Blt_UnCheckColorKey(POINT pos, int iSpr, int iSurface = 0);
	void			DDBlt(POINT pos, int iSpr);
	void			DDBltFast(POINT pos, int iSpr);
	void			Flip(HDC hDC, int x = 0, int y = 0, int iSurface = 0);
	void			Flip(int x = 0, int y = 0, int iSurface = 0);
	void			FlipRect(HDC hDC, RECT rect, int x = 0, int y = 0, int iSurface = 0);

	virtual	void	SetScrollPos(POINT scrpos, int iImg);

	void			DrawBox(RECT rect, BYTE r = 255, BYTE g = 255, BYTE b = 255, int w = 1, int iImg = 0, bool fPenStyle = false);
	void			DrawFillBox(RECT rect, BYTE r = 255, BYTE g = 255, BYTE b = 255, int iImg = 0, bool fPenStyle = false);
	void			DrawLineHV(RECT rect, RGB color, int iImg);
	void			DrawLine(RECT rect, RGB rgb, int width = 1, int iImg = 0, LPBYTE lppen = NULL, int iRadius = 1, bool bBrush = false, int iColorLevelCount = 10);

	//Sound
	HRESULT			PlayBGM(LPSTR lpFileName, BYTE byFileType, bool bLoop);
	HRESULT			PlaySE(LPSTR lpFileName, BYTE byFileType, bool bLoop);
	void			PauseBGM(bool bPause);
	void			PauseSE(bool bPause);
	void			PauseSE(BYTE byBuf, bool bPause);
	void			StopBGM();
	void			StopSE();
	void			StopSE(BYTE byBuf);
	void			SetVolumeBGM(short sVolume);
	void			SetVolumeSE(short sVolume);
	void			SetVolumeSE(BYTE byBuf, short sVolume);

	//Engine
	LPENGINE		EngGetEngineSetup()				{ return m_pEng; };
	LPSTR			EngGetAppName()					{ return m_pEng->m_lpAppName; };
	HWND			EngGethWnd()					{ if(this) return m_pEng->m_hWnd; else return NULL; };
	HDC				EngGethDC()						{ return m_pEng->m_hDC; };
	RECT			EngGetGameViewRect()			{ return m_pEng->m_rctView; };
	RECT			EngGetGameScreenRect()			{ return m_pEng->m_rctScreen; };
	int				EngGetWidth()					{ return m_pEng->m_iWidth; };
	int				EngGetHeight()					{ return m_pEng->m_iHeight; };
	BYTE			EngGetColorBits()				{ return m_pEng->m_byColorBits; };
	int				EngGetMaxSprite()				{ return m_pEng->m_iMaxSprite; };
	BYTE			EngGetMaxMChip()				{ return m_pEng->m_iMaxMChip; };
	DWORD			EngGetColorKey()				{ return m_pEng->m_dwColorKey; };
	bool			EngGetDirectDrawUse()			{ return m_pEng->DirectXUse.m_bDirectDrawUse; };
	bool			EngGetFullScreen()				{ return m_pEng->DirectXUse.m_bFullScreen; };
	POINT			EngGetMapChipSize()				{ return m_pEng->m_MapChipSize; };
	BYTE			EngGetMapIndex(int iMapcnt)		{ return m_pEng->m_byMapIndex[iMapcnt]; };
	int				EngGetMaxRunCase()				{ return m_pEng->m_iMaxRunCase; };
	int				EngGetMaxEvent()				{ return m_pEng->m_iMaxEvent; };
	int				EngGetMaxEventPage()			{ return m_pEng->m_iMaxEventPage; };
	int				EngGetMaxSwitch()				{ return m_pEng->m_iMaxSwitch; };
	WORD			EngGetFrameCount()				{ return m_pEng->m_wFrameCount; };
	bool			EngGetFrameSkip()				{ return m_pEng->m_bFrameSkip; };
	bool			EngGetFrameDelay()				{ return m_pEng->m_bFrameDelay; };
	int				EngGetMaxAniCmd()				{ return m_pEng->m_iMaxAniCmd; };

	void			EngSethWnd(HWND hWnd)			{ m_pEng->m_hWnd = hWnd; };
	void			EngSetAppName(LPSTR lpAppName)	{ strcpy(m_pEng->m_lpAppName, lpAppName); };
	void			EngSetWidth(int iW)				{ m_pEng->m_iWidth = iW; };
	void			EngSetHeight(int iH)			{ m_pEng->m_iHeight = iH; };
	void			EngSetColorBits(BYTE byBits)	{ m_pEng->m_byColorBits = byBits; };
	void			EngSetColorKey(DWORD dwCKey)	{ m_pEng->m_dwColorKey = dwCKey; };
	void			EngSetColorKey(BYTE r, BYTE g, BYTE b);
	void			EngSetUseMap(BYTE byUseMap)		{ m_pEng->m_byUseMap = byUseMap;};
	void			EngSetMaxSprite(int iCnt)		{ m_pEng->m_iMaxSprite = iCnt; };
	void			EngSetMaxMChip(BYTE byCnt)		{ m_pEng->m_iMaxMChip = byCnt; };
	void			EngSetGameView(RECT rect)		{ m_pEng->m_rctView = rect; };
	void			EngSetFilePath(LPSTR lpPath);
	void			EngSetFrameCount(int iFrmCnt)	{ m_pEng->m_wFrameCount = iFrmCnt; };
	void			EngSetFrameSkip(bool bFrmSkip)	{ m_pEng->m_bFrameSkip = bFrmSkip; };
	void			EngSetFrameDelay(bool bFrmDelay){ m_pEng->m_bFrameDelay = bFrmDelay; };
};

#endif // !defined(AFX_GAMEENGINE_H__25BABC0A_615B_11D4_ABAF_00104B15DFC2__INCLUDED_)
