#include "GameEngine.h"

#ifdef MISTERYENGINE_EXPORTS
#define MISTERYENGINE_API __declspec(dllexport)
#else
#define MISTERYENGINE_API __declspec(dllimport)
#endif

class CJpg;

class MISTERYENGINE_API CMisteryEngine {
public:
	CMisteryEngine(void);
	virtual ~CMisteryEngine(void);

protected:
	CGameEngine		*m_pEng;
	CJpg			*m_pImg;

public:
	//Engine, Main
	bool			ME_CreateEngine(LPENGINE lpEngineSetting, HWND hWnd = NULL);// 
	void			ME_SetUpdateFrame(bool bUpdate = true);//Ʈ ÷ ()
	LRESULT			ME_GameProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);//()
	bool			ME_GameProcMFC(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, HDC hDC);//()
	bool			ME_IsCreateEngine();// Ǿ ִ°

	//Load Image
	LRESULT			ME_LoadBmp(LPSTR lpFileName, bool bDirectDrawUse = false, bool bConvertColorBit = false, BYTE byConvertColorBit = 16, LPIMAGEDATA lpImageData = NULL);//Ʈ ε
	LRESULT			ME_LoadJpg(LPSTR lpFileName, bool bDirectDrawUse = false, bool bConvertColorBit = false, BYTE byConvertColorBit = 16, LPIMAGEDATA lpImageData = NULL);//JPG ε
	LPIMAGEDATA		ME_GetLoadedImageData();//ε ̹ϵ 

	//Surface
	LRESULT			ME_CreateSurface(int w, int h, int iCnt, DWORD dwColorKey = 0);//鼭ǽ 
	LRESULT			ME_AddBackSurface(int w, int h, DWORD dwColorKey = 0);//Ѽǽ ߰
	int				ME_GetCurrentBackSurface();// ǽ 
	WORD			ME_GetFirstSurfaceNULL();//ù° ִ ǽȣ
	bool			ME_IsBackSurface(int iSur);//鼭ǽ ִ°
	LRESULT			ME_SetBackSurfaceSize(int w, int h, int iSur, DWORD dwColorKey = 0);//鼭ǽ  
	void			ME_DeleteSurface(int iSur);//鼭ǽ 
	void			ME_DeleteCurrentSurface();// ߿ ߰ 鼭ǽ 
	void			ME_DeleteAllSurface();// 鼭ǽ 
	POINT			ME_GetBackSurfaceSize(int iSur);//鼭ǽ 
	long			ME_GetSurfacePitch(int iSur);//鼭ǽ ġ 
	
	//Sprite
	LRESULT			ME_AddSprite(int w, int h, LPBYTE lpData, int *piSpr = NULL, bool bAddCnt = true);//Ʈ ߰
	void			ME_DeleteSprite(int iSpr, bool bAddCnt = true);//Ʈ 
	void			ME_DeleteAllSprite();// Ʈ 
	long			ME_GetSpritePitch(int iImg);//Ʈ ġ 
	LPBYTE			ME_GetSpriteBuffer(int iSpr);//Ʈ  
	void			ME_GetSpriteRectBuffer(LPBYTE lpDest, RECT rect, int iSpr);//簢 ŭ ۸ 
	POINT			ME_GetSpriteSize(int iSpr);//Ʈ 
	int				ME_GetCurrentSprite();// ߰ Ʈ 
	int				ME_GetSpriteCount();//Ʈ Ѱ
	int				ME_GetSpriteBufSize(int iSpr);//Ʈ ̹ 
//	void			ME_GetSpriteGraphic(LPGRAPHIC lpGra, int iSpr);
//	LPGRAPHIC		ME_GetSpriteGraphic(int iSpr);
	void			ME_SetSpriteBuffer(int iSpr, LPBYTE lpBuf);//Ʈ ۹ٲ(̹ ũⰡ ƾ )
//	void			ME_SetSpriteGraphic(LPGRAPHIC lpGra, int iSpr);
	void			ME_SetChangeSprite(int iSpr1, int iSpr2);

	//Functions for MisteryEngine setting
	HWND			ME_EngGethWnd() { if(this) return m_pEng->EngGethWnd();	else return NULL; };// ڵ

	//Draw
	void			ME_ClearSurface(int iImg = 0);//鼭ǽ 0 ʱȭ
	void			ME_FillSprite(DWORD dwColor, int iImg = 0);//Ʈ  ä
	void			ME_EffectBlt(POINT pos, int iImg[2], BYTE byLevel, BYTE byEffectFlag = 0);//Ʈ  byEffectFlag = EBF_ALPHA, EBF_FADE
#ifdef VERSION_FULL
	void			ME_EffectBltZoomIn(POINT pos, int iImg[2], BYTE byLevel, float fZoom, BYTE byEffectFlag = 0);// 
#endif
	void			ME_CopySurface(int iDest, int iSrc);//鼭ǽ 
	bool			ME_BltZoomIn(POINT pos, LPRECT lpBltRect, float fZoom, int iSpr, int iSurface = 0);//Ȯ
	bool			ME_CopySurfaceToSprite(int iSpr, int iSurface = 0);//鼭ǽ Ʈ ۷ 
	bool			ME_BltZoomOut(POINT pos, BYTE byZoom, int iSpr, int iSurface = 0);// ׸
	bool			ME_BltZoomOutSurface(POINT pos, BYTE byZoom, int iSrcSurface, int iDestSurface = 0);//鼭ǽ 
	void			ME_Blt(POINT pos, int iSpr, int iSurface = 0);//׸
	void			ME_Blt_UnCheckColorKey(POINT pos, int iSpr, int iSurface = 0);//÷Ű  ׸
#ifdef DEBUG_DDRAW_BUFFER
	void			ME_DDBlt(POINT pos, int iSpr);//
	void			ME_DDBltFast(POINT pos, int iSpr);//
#endif
	void			ME_Flip(int x = 0, int y = 0, int iSurface = 0);//鼭ǽ  ȭ鿡 ǥ
	void			ME_Flip(HDC hDC, int x = 0, int y = 0, int iSurface = 0);//鼭ǽ  ȭ鿡 ǥ

	//Sound.. New!
	HRESULT			ME_PlayBGM(LPSTR lpFileName, BYTE byFileType, bool bLoop);
	HRESULT			ME_PlaySE(LPSTR lpFileName, BYTE byFileType, bool bLoop);
	void			ME_PauseBGM(bool bPause);
	void			ME_PauseSE(bool bPause);
	void			ME_PauseSE(BYTE byBuf, bool bPause);
	void			ME_StopBGM();
	void			ME_StopSE();
	void			ME_StopSE(BYTE byBuf);
	void			ME_SetVolumeBGM(int iVolume);
	void			ME_SetVolumeSE(int iVolume);
	void			ME_SetVolumeSE(BYTE byBuf, int iVolume);

//
	HDC				ME_EngGethDC()				{ return m_pEng->EngGethDC(); };
};
