// MisteryEngine_API.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"

////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
#include <MisteryEngine.h>

CMisteryEngine		*m_pME_Eng		= NULL;
bool				m_bUpdateFrame	= false;
void				UpdateFrame();
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];								// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];								// The title bar text

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_MISTERYENGINE_API, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_MISTERYENGINE_API);

////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	m_bUpdateFrame = true;
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////

	// Main message loop:
/*	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}*/
	for(;;)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0))
				return msg.wParam;
		}
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	SAFE_DELETE(m_pME_Eng);

	return msg.wParam;
}

ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_MISTERYENGINE_API);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_MISTERYENGINE_API;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	ENGINE			eng;
	LPIMAGEDATA		lpImageData = NULL;

	ZeroMemory(&eng, sizeof(eng));

	eng.DirectXUse.m_bChangeDisplay		= true;
    eng.DirectXUse.m_bDirectDrawUse		= true;
    eng.DirectXUse.m_bDirectSoundUse	= true;
    eng.DirectXUse.m_bFullScreen		= true;
	eng.DirectXUse.m_byDDMemoryFlags	= DDMF_SYSTEM;
	eng.m_colorKeyRGB.SetRGB(0, 0, 0);
	eng.m_byMaxSoundBuf					= 10;
	eng.m_hWnd							= hWnd;
	eng.m_iWidth						= 640;
	eng.m_iHeight						= 480;
	eng.m_iMaxBackSurfaceCount			= 5;
	eng.m_iMaxSprite					= 10;
	eng.m_byColorBits					= 16;
	eng.m_dwColorKey					= 0;
	SET_RECT(eng.m_rctView, 0, 0, eng.m_iWidth, eng.m_iHeight);//ȭ ũ(̷ƮX Ҷ âϰ ݵ ؾ)

	m_pME_Eng = new CMisteryEngine();

	if(m_pME_Eng->ME_CreateEngine(&eng)) {
		if(m_pME_Eng->ME_LoadBmp("image\\a.bmp", eng.DirectXUse.m_bDirectDrawUse, true, 16) == BMP_OK)
		{
			lpImageData = m_pME_Eng->ME_GetLoadedImageData();

			m_pME_Eng->ME_AddSprite(lpImageData->m_iW, lpImageData->m_iH, lpImageData->m_lpData);
		}

		if(m_pME_Eng->ME_LoadBmp("image\\.bmp", eng.DirectXUse.m_bDirectDrawUse, true, 16) == BMP_OK)
		{
			lpImageData = m_pME_Eng->ME_GetLoadedImageData();

			m_pME_Eng->ME_AddSprite(lpImageData->m_iW, lpImageData->m_iH, lpImageData->m_lpData);
		}

		if(m_pME_Eng->ME_LoadJpg("image\\et.jpg", eng.DirectXUse.m_bDirectDrawUse, true, 16) == JPG_OK)
		{
			lpImageData = m_pME_Eng->ME_GetLoadedImageData();

			m_pME_Eng->ME_AddSprite(lpImageData->m_iW, lpImageData->m_iH, lpImageData->m_lpData);
		}

		m_pME_Eng->ME_PlayBGM("sound\\f.wav", TYPE_WAV, true);
		m_pME_Eng->ME_PlaySE("sound\\um.wav", TYPE_WAV, false);
		m_pME_Eng->ME_PlaySE("sound\\f2.wav", TYPE_WAV, false);
	}
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
//	PAINTSTRUCT ps;
//	HDC hdc;
	TCHAR szHello[MAX_LOADSTRING];
	LoadString(hInst, IDS_HELLO, szHello, MAX_LOADSTRING);

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		case WM_KEYDOWN:
			if(wParam == VK_ESCAPE)
				PostQuitMessage(0);
/*		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			// TODO: Add any drawing code here...
			RECT rt;
			GetClientRect(hWnd, &rt);
			DrawText(hdc, szHello, strlen(szHello), &rt, DT_CENTER);
			EndPaint(hWnd, &ps);
			break;*/
		default:
////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
			UpdateFrame();
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////

			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}


////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
void UpdateFrame()
{
	static	BYTE byLevel = 0;
	POINT	pos			= {0, 0};
	int		iImg[2]		= {0, 1};

	if(m_bUpdateFrame) {
		m_pME_Eng->ME_ClearSurface(0);
		m_pME_Eng->ME_Blt(pos, 0);
		m_pME_Eng->ME_EffectBlt(pos, iImg, byLevel, EBF_FADE);

		pos.x	+= 300;
		iImg[1] = 2;

		m_pME_Eng->ME_EffectBlt(pos, iImg, byLevel, EBF_ALPHA);
		m_pME_Eng->ME_Flip(m_pME_Eng->ME_EngGethDC());

		if(++byLevel > 31)
			byLevel = 0;
	}
}
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////



//*****κ

//ؿ ڵκ  ƽð ̷ƮX
// ϰ  ƮĿ 
//ָ ˴ϴ.

/*
ENGINE		eng;//    ó

ZeroMemory(&eng, sizeof(eng));//Ʈ ͸ ʱȭ

eng.DirectXUse.m_bChangeDisplay		= true;*/
/* ÷Ʈ ũž ÷ ÷Ʈ ٸ
	eng.m_byColorBits   ÷Ʈ ÷Ʈ ٲ۴*/
/*
eng.DirectXUse.m_bDirectDrawUse		= false;
//̷Ʈ Ұΰ

eng.DirectXUse.m_bDirectSoundUse	= true;
//̷Ʈ带 Ұΰ

eng.DirectXUse.m_bFullScreen		= false;
//üȭΰ

eng.DirectXUse.m_bKeyBoardUse		= false;
//()

eng.DirectXUse.m_bMouseUse			= false;
//()

eng.DirectXUse.m_byDDMemoryFlags	= DDMF_SYSTEM;
/*DDMF_LOCAL, DDMF_NONLOCAL, DDMF_VIDEO, DDMF_SYSTEM
	̷Ʈο ǥ ޸ ġ, DEFAULT ý۸޸*/
/*
eng.m_byMaxSoundBuf			= 30;
//尡 ÿ µ ִ밹 Ѵ

eng.m_iWidth				= 640;
// ũ,  üȭ϶ 640, 800, 1024, 1152...θ ؾ

eng.m_iHeight				= 480;
// ũ,  üȭ϶ 480, 600, 768, 864...θ ؾ

eng.m_iMaxBackSurfaceCount	= 5;
//鼭ǽ ִ밹 1 - 65535

eng.m_iMaxSprite			= 10;
//Ʈ ִ밹 1 - 65535

eng.m_byColorBits			= 16;
// ÷Ʈ	16Ʈ ȭ Ǿ, 8Ʈϳ 24Ʈ ̻ 

eng.m_dwColorKey			= 0;
//ӿ  ÷Ű

m_pME_Eng = new CMisteryEngine();
// ,  CMisteryEngineŬ͸  μ

if(m_pME_Eng->ME_CreateEngine(&eng)) {// 
	// ó
}
*/