// MisteryEngine_MFCView.cpp : implementation of the CMisteryEngine_MFCView class
//

#include "stdafx.h"
#include "MisteryEngine_MFC.h"

#include "MisteryEngine_MFCDoc.h"
#include "MisteryEngine_MFCView.h"

////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
#include <MisteryEngine.h>
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMisteryEngine_MFCView

IMPLEMENT_DYNCREATE(CMisteryEngine_MFCView, CView)

BEGIN_MESSAGE_MAP(CMisteryEngine_MFCView, CView)
	//{{AFX_MSG_MAP(CMisteryEngine_MFCView)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMisteryEngine_MFCView construction/destruction

CMisteryEngine_MFCView::CMisteryEngine_MFCView()
{
	// TODO: add construction code here
////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	m_pME_Eng = NULL;
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////
}

CMisteryEngine_MFCView::~CMisteryEngine_MFCView()
{
////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	SAFE_DELETE(m_pME_Eng);
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////
}

BOOL CMisteryEngine_MFCView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMisteryEngine_MFCView drawing

void CMisteryEngine_MFCView::OnDraw(CDC* pDC)
{
	CMisteryEngine_MFCDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	static BYTE byLevel = 0;
	POINT	pos			= {0, 0};
	int		iImg[2]		= {0, 1};

	m_pME_Eng->ME_ClearSurface(0);
	m_pME_Eng->ME_Blt(pos, 0);
	m_pME_Eng->ME_EffectBlt(pos, iImg, byLevel, EBF_FADE);

	pos.x	+= 300;
	iImg[1] = 2;

	m_pME_Eng->ME_EffectBlt(pos, iImg, byLevel, EBF_ALPHA);
	m_pME_Eng->ME_Flip(pDC->m_hDC);

	if(++byLevel > 31)
		byLevel = 0;
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////
// CMisteryEngine_MFCView diagnostics

#ifdef _DEBUG
void CMisteryEngine_MFCView::AssertValid() const
{
	CView::AssertValid();
}

void CMisteryEngine_MFCView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMisteryEngine_MFCDoc* CMisteryEngine_MFCView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMisteryEngine_MFCDoc)));
	return (CMisteryEngine_MFCDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMisteryEngine_MFCView message handlers

void CMisteryEngine_MFCView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	CMisteryEngine_MFCApp *pApp = (CMisteryEngine_MFCApp*)AfxGetApp();
	ENGINE			eng;
	LPIMAGEDATA		lpImageData = NULL;

	m_pME_Eng = new CMisteryEngine();

	ZeroMemory(&eng, sizeof(eng));

	eng.m_hWnd							= pApp->m_pMainWnd->m_hWnd;
    eng.DirectXUse.m_bDirectSoundUse	= true;
	eng.m_colorKeyRGB.SetRGB(0, 0, 0);
	eng.m_byMaxSoundBuf					= 10;
	eng.m_iWidth						= 640;
	eng.m_iHeight						= 480;
	eng.m_iMaxBackSurfaceCount			= 5;
	eng.m_iMaxSprite					= 10;
	eng.m_byColorBits					= 16;
	eng.m_dwColorKey					= 0;
	SET_RECT(eng.m_rctView, 0, 0, eng.m_iWidth, eng.m_iHeight);//ȭ ũ(̷ƮX Ҷ âϰ ݵ ؾ)

	if(m_pME_Eng->ME_CreateEngine(&eng)) {
		if(m_pME_Eng->ME_LoadBmp("image\\a.bmp", eng.DirectXUse.m_bDirectDrawUse, true, 16) == BMP_OK)
		{
			lpImageData = m_pME_Eng->ME_GetLoadedImageData();

			m_pME_Eng->ME_AddSprite(lpImageData->m_iW, lpImageData->m_iH, lpImageData->m_lpData);
		}

		if(m_pME_Eng->ME_LoadBmp("image\\.bmp", eng.DirectXUse.m_bDirectDrawUse, true, 16) == BMP_OK)
		{
			lpImageData = m_pME_Eng->ME_GetLoadedImageData();

			m_pME_Eng->ME_AddSprite(lpImageData->m_iW, lpImageData->m_iH, lpImageData->m_lpData);
		}

		if(m_pME_Eng->ME_LoadJpg("image\\et.jpg", eng.DirectXUse.m_bDirectDrawUse, true, 16) == BMP_OK)
		{
			lpImageData = m_pME_Eng->ME_GetLoadedImageData();

			m_pME_Eng->ME_AddSprite(lpImageData->m_iW, lpImageData->m_iH, lpImageData->m_lpData);
		}

		m_pME_Eng->ME_PlayBGM("sound\\f.wav", TYPE_WAV, true);
		m_pME_Eng->ME_PlaySE("sound\\um.wav", TYPE_WAV, false);
		m_pME_Eng->ME_PlaySE("sound\\f2.wav", TYPE_WAV, false);
	}

	SetTimer(0, 1, NULL);
////////////////////////////////////////////////////////////////////////////////////
}

void CMisteryEngine_MFCView::OnDestroy() 
{
	CView::OnDestroy();

////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	KillTimer(0);
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////
}

void CMisteryEngine_MFCView::OnTimer(UINT nIDEvent) 
{
////////////////////////////////////////////////////////////////////////////////////
//Mistery Engine
	Invalidate(FALSE);
//Mistery Engine
////////////////////////////////////////////////////////////////////////////////////

	CView::OnTimer(nIDEvent);
}


/*
//****** κ

ENGINE			eng;

ZeroMemory(&eng, sizeof(eng));

eng.DirectXUse.m_bChangeDisplay		= true;
eng.DirectXUse.m_bDirectDrawUse		= false;
eng.DirectXUse.m_bDirectSoundUse	= true;
eng.DirectXUse.m_bFullScreen		= false;
eng.DirectXUse.m_bKeyBoardUse		= false;
eng.DirectXUse.m_bMouseUse			= false;
eng.DirectXUse.m_byDDMemoryFlags	= DDMF_SYSTEM;
eng.m_byMaxSoundBuf			= 30;
eng.m_iWidth				= 640;
eng.m_iHeight				= 480;
eng.m_iMaxBackSurfaceCount	= 5;
eng.m_iMaxSprite			= 10;
eng.m_byColorBits			= 16;
eng.m_dwColorKey			= 0;

m_pME_Eng = new CMisteryEngine();

if(m_pME_Eng->ME_CreateEngine(&eng)) {
	// ó
}


//*****κ

//ؿ ڵκ  ƽð ̷ƮX
// ϰ  ƮĿ 
//ָ ˴ϴ.


ENGINE		eng;//    ó

ZeroMemory(&eng, sizeof(eng));//Ʈ ͸ ʱȭ

eng.DirectXUse.m_bChangeDisplay		= true;
/* ÷Ʈ ũž ÷ ÷Ʈ ٸ
	eng.m_byColorBits   ÷Ʈ ÷Ʈ ٲ۴*/
/*
eng.DirectXUse.m_bDirectDrawUse		= false;
//̷Ʈ Ұΰ

eng.DirectXUse.m_bDirectSoundUse	= true;
//̷Ʈ带 Ұΰ

eng.DirectXUse.m_bFullScreen		= false;
//üȭΰ

eng.DirectXUse.m_bKeyBoardUse		= false;
//()

eng.DirectXUse.m_bMouseUse			= false;
//()

eng.DirectXUse.m_byDDMemoryFlags	= DDMF_SYSTEM;
/*DDMF_LOCAL, DDMF_NONLOCAL, DDMF_VIDEO, DDMF_SYSTEM
	̷Ʈο ǥ ޸ ġ, DEFAULT ý۸޸*/
/*
eng.m_byMaxSoundBuf			= 30;
//尡 ÿ µ ִ밹 Ѵ

eng.m_iWidth				= 640;
// ũ,  üȭ϶ 640, 800, 1024, 1152...θ ؾ

eng.m_iHeight				= 480;
// ũ,  üȭ϶ 480, 600, 768, 864...θ ؾ

eng.m_iMaxBackSurfaceCount	= 5;
//鼭ǽ ִ밹 1 - 65535

eng.m_iMaxSprite			= 10;
//Ʈ ִ밹 1 - 65535

eng.m_byColorBits			= 16;
// ÷Ʈ	16Ʈ ȭ Ǿ, 8Ʈϳ 24Ʈ ̻ 

eng.m_dwColorKey			= 0;
//ӿ  ÷Ű

m_pME_Eng = new CMisteryEngine();
// ,  CMisteryEngineŬ͸  μ

if(m_pME_Eng->ME_CreateEngine(&eng)) {// 
	// ó
}
*/
