// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of Common C++.
// 
// The exception is that, if you link the Common C++ library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the Common C++ library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name Common C++.  If you copy code from other releases into a copy of
// Common C++, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for Common C++, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "config.h"
#include "macros.h"
#include "thread.h"
#include "persist.h"
#include "html.h"

void Writer::WriteSomeOutput(const string& stuff, bool newLine)
{
  cout << stuff;
  if (newLine)
	cout << endl;
}

  IMPLEMENT_PERSISTENCE(Entity,"::Entity");

  Entity::Entity()
	: myName(""),
	  myTerminated(false)
  {
	mySettings.clear();
	myEntities.clear();
	myAttributes.clear();
  }

  Entity::Entity(const string & name)
	: myName(name),
	  myTerminated(false)
  {
	mySettings.clear();
	myEntities.clear();
	myAttributes.clear();
  }

  Entity::~Entity()
  {
	mySettings.clear();
	for(int i=0; i < myEntities.size(); ++i)
		delete myEntities[i];
	myEntities.clear();
	myAttributes.clear();
  }

  bool Entity::Write(Engine& archive) const
  {
	// Write the state of the Entity to disk
	archive << myName << myTerminated << myNewLine << mySettings
			<< myAttributes << myEntities << myContent;
	return true;
  }

  bool Entity::Read(Engine& archive)
  {
	archive >> myName >> myTerminated >> myNewLine >> mySettings
			>> myAttributes >> myEntities >> myContent;
	return true;
  }

  void Entity::OutputHTML(Writer& wr) const
  {
	if (myName == string(""))
	  {
		wr.WriteSomeOutput(myContent,myNewLine);
	  }
	else
	  {
		wr.WriteSomeOutput(string("<"),false);
		wr.WriteSomeOutput(myName,false);
		if (myAttributes.size() > 0)
		  {
			for(int i=0; i < myAttributes.size(); ++i)
			  {
				wr.WriteSomeOutput(string(" "),false);
				wr.WriteSomeOutput(myAttributes[i],false);
			  }
		  }
		if (mySettings.size() > 0)
		  {
			for(StringMap::const_iterator it = mySettings.begin(); it != mySettings.end(); ++it)
			  {
				wr.WriteSomeOutput(string(" "),false);
				wr.WriteSomeOutput(it->first,false);
				wr.WriteSomeOutput(string("=\""),false);
				wr.WriteSomeOutput(it->second,false);
				wr.WriteSomeOutput(string("\""),false);
			  }
		  }
		wr.WriteSomeOutput(string(">"),myNewLine);
		if (myContent != string(""))
		  wr.WriteSomeOutput(myContent,myNewLine);
		for(int i=0; i < myEntities.size(); ++i)
		  myEntities[i]->OutputHTML(wr);
		if (myTerminated)
		  {
			wr.WriteSomeOutput(string("</"),false);
			wr.WriteSomeOutput(myName,false);
			wr.WriteSomeOutput(string(">"),myNewLine);
		  }
	  }
  }

  // Implement the serialisation...
  IMPLEMENT_PERSISTENCE(HTMLDocument,"::HTMLDocument");

  HTMLDocument::HTMLDocument()
	: Entity(string("HTML"))
  {
	// No state to initialise
  }

  HTMLDocument::~HTMLDocument()
  {
	// No state to destroy - handled by the Entity isn't it?
  }

  HTMLDocument::HTMLDocument(bool frameset)
	: Entity(string("HTML"))
  {
	// Here we need to specify our frameset child entities
	GetEntities().push_back(new Head());
	if (frameset)
	  GetEntities().push_back(new Frameset());
	else
	  GetEntities().push_back(new Body());
  }


  Head& HTMLDocument::GetHeadEntity()
  {
	if (GetEntities().size() == 0)
	  {
		GetEntities().push_back(new Head());
		GetEntities().push_back(new Body());
	  }
	return *((Head*)(GetEntities()[0]));
  }

  Body& HTMLDocument::GetBodyEntity()
  {
	if (GetEntities().size() == 0)
	  {
		GetEntities().push_back(new Head());
		GetEntities().push_back(new Body());
	  }
	return *((Body*)(GetEntities()[1]));
  }

  void HTMLDocument::OutputHTML(Writer& wr) const
  {
	wr.WriteSomeOutput(string("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">"),true);
	Entity::OutputHTML(wr);   
  }
/** EMACS **
 * Local variables:
 * mode: c++
 * c-basic-offset: 8
 * End:
 */
