// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of Common C++.
// 
// The exception is that, if you link the Common C++ library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the Common C++ library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name Common C++.  If you copy code from other releases into a copy of
// Common C++, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for Common C++, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "config.h"
#include "macros.h"
#include "persist.h"
#include "assert.h"

USING(std)

PersistException::PersistException(string const& reason)
  : myMessage(reason)
{
  // Nothing :)
}

PersistException::~PersistException()
{
  // Nothing :)
}

string const& PersistException::GetMessage() const
{
  return myMessage;
}

const char* BaseObject::GetPersistenceID() const
{
  return "BaseObject";
}

BaseObject::BaseObject()
{
  // Do nothing
}

BaseObject::~BaseObject()
{
  // Do nothing
}

bool BaseObject::Write(Engine& archive) const
{
  // Do nothing
  return true; // Successfully
}

bool BaseObject::Read(Engine& archive)
{
  // Do nothing
  return true; // Successfully
}

TypeManager::StringFunctionMap* theInstantiationFunctions = 0;
int refCount = 0;

TypeManager::StringFunctionMap& _Internal_GetMap()
{
	return *theInstantiationFunctions;
}
void TypeManager::Add(const char* name, NewBaseObjectFunction construction)
{
  if (refCount++ == 0)
  {
    theInstantiationFunctions = new StringFunctionMap;
  }
  assert(_Internal_GetMap().find(string(name)) == _Internal_GetMap().end());
  _Internal_GetMap()[string(name)] = construction;
}

void TypeManager::Remove(const char* name)
{
  assert(_Internal_GetMap().find(string(name)) != _Internal_GetMap().end());
  _Internal_GetMap().erase(_Internal_GetMap().find(string(name)));
  if (--refCount == 0)
  {
    delete theInstantiationFunctions;
	theInstantiationFunctions = 0;
  }
}

BaseObject* TypeManager::CreateInstanceOf(const char* name)
{
  assert(refCount);
  assert(_Internal_GetMap().find(string(name)) != _Internal_GetMap().end());
  return (_Internal_GetMap()[string(name)])();
}


/** EMACS **
 * Local variables:
 * mode: c++
 * c-basic-offset: 8
 * End:
 */
