//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
///////////			CDirectDraw 						//////////////
//////////////////////////////////////////////////////////////////////
///////////	 2001. 01. 10. Thr.							//////////////
//////////									by Donbu    //////////////
//////////////////////////////////////////////////////////////////////

//DirectDraw.cpp : Implementation of the CDirectDraw Class

#include "DirectDraw.h"

CDirectDraw::CDirectDraw()
{

	m_lpDD = NULL;
	m_lpDBSurface = NULL;
	m_lpDPSurface = NULL;


	//DebugUtil ʱȭ 
	m_debug.OpenFilePointer(DEBUG_FILENAME_DRAW);

//	DirectDrawInit();
}

CDirectDraw::~CDirectDraw()
{
	if(m_lpDD)ReleaseAllObject();
	
	m_debug.CloseFilePointer();
}

CDirectDraw::DirectDrawInit(HWND hwnd, int width, int height, int bpp)
{
	DDSURFACEDESC ddsd;
	DDSCAPS       ddscaps;
	HRESULT       hRet;

	m_hwnd = hwnd;

	m_width = width;
	m_height = height;
	m_bpp = bpp;

	hRet = ::DirectDrawCreate(NULL, &m_lpDD, NULL);
	if(hRet != DD_OK){
		wsprintf(m_debug.ErrMsg, "CDirectDraw : DirectDrawCreate Error!!\n");
		m_debug.ErrFile();
		m_debug.CloseFilePointer();
		//m_debug.ErrMsgBox();
	}
	
	//Cooperative Level Setting
	hRet = m_lpDD->SetCooperativeLevel(m_hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);

	hRet = m_lpDD->SetDisplayMode(m_width, m_height, m_bpp);
    if(hRet != DD_OK){	
		wsprintf(m_debug.ErrMsg, "CDirectDraw : SetDisplayMode Error!!\n");
		m_debug.ErrFile();
		m_debug.CloseFilePointer();
		//m_debug.ErrMsgBox();
	}

	wsprintf(m_debug.ErrMsg, "CDirectDraw : Width : %d\n", m_width);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "CDirectDraw : Height : %d\n", m_height);
	m_debug.ErrFile();
	

	::ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	//Primary Surface Creating
	hRet = m_lpDD->CreateSurface(&ddsd, &m_lpDPSurface, NULL);
	if(hRet != DD_OK){
		
		wsprintf(m_debug.ErrMsg, "CDirectDraw : Primary Surface Create Error!!\n");
		m_debug.ErrFile();
		m_debug.CloseFilePointer();
		//m_debug.ErrMsgBox();
	}

	//BackBuffer Creating
	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	hRet = m_lpDPSurface->GetAttachedSurface(&ddscaps, &m_lpDBSurface);
	if(hRet != DD_OK){		
		wsprintf(m_debug.ErrMsg, "CDirectDraw : BackeBuffer Create Error!!\n");
		m_debug.ErrFile();
		m_debug.CloseFilePointer();
		//m_debug.ErrMsgBox();
	}

	ClearSurface(m_lpDPSurface);
	ClearSurface(m_lpDBSurface);
	
	m_debug.CloseFilePointer();
	return TRUE;
}

CDirectDraw::ReStore()
{
	HRESULT hRet;
	hRet = m_lpDPSurface->IsLost();
	if(hRet == DDERR_SURFACELOST)
		m_lpDPSurface->Restore();
}

BOOL CDirectDraw::ClearSurface(LPDIRECTDRAWSURFACE pSurface)
{
/*	DDSURFACEDESC ddsd;
	WORD SurfaceBuf;
	UINT SurfaceWidth, SurfaceHeight;
	int MemSize;

	memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	pSurface->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);

	SurfaceWidth = ddsd.dwWidth;
	SurfaceHeight = ddsd.dwHeight;
	SurfaceBuf   = (WORD)ddsd.lpSurface;
	
	//DebugUtil
	MemSize = SurfaceWidth * SurfaceHeight; 

	
	memset(&SurfaceBuf, 0, MemSize);

	pSurface->Unlock(NULL);

	
	wsprintf(m_debug.ErrMsg, "CDirectDraw : ClearSurface : Width : %d", SurfaceWidth);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "CDirectDraw : ClearSurface : Height : %d", SurfaceHeight);
	m_debug.ErrFile();
		wsprintf(m_debug.ErrMsg, "CDirectDraw : ClearSurface : MemSize : %d", MemSize);
	m_debug.ErrFile();	
	m_debug.CloseFilePointer();*/

	DDBLTFX ddbltfx;

	ddbltfx.dwSize = sizeof(DDBLTFX);
	ddbltfx.dwFillColor = 20;
	
	pSurface->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);


	return TRUE;
}

CDirectDraw::ReleaseAllObject()
{
	if(m_lpDD != NULL)
	{
		if(m_lpDPSurface != NULL)
		{
			m_lpDPSurface->Release();
			m_lpDPSurface = NULL;
		}
		m_lpDD->Release();
		m_lpDD = NULL;
	}
}

CDirectDraw::FilpSurface()
{
	HRESULT hRet;

	hRet = m_lpDPSurface->Flip(NULL, 0);
}

LPDIRECTDRAW CDirectDraw::GetDirectDraw()
{
	return m_lpDD;
}

LPDIRECTDRAWSURFACE CDirectDraw::GetDDPrimary()
{
	return m_lpDPSurface;
}

LPDIRECTDRAWSURFACE CDirectDraw::GetDDBack()
{
	return m_lpDBSurface;
}

int CDirectDraw::GetWidth()
{
	return m_width;
}

int CDirectDraw::GetHeight()
{
	return m_height;
}






	