//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//		DirectDraw class Test Main						//////////////
//////////////////////////////////////////////////////////////////////
////////////        2001. 01. 10 .wed					//////////////
///////////								by Donbu		//////////////
//////////////////////////////////////////////////////////////////////


//Includes
#include<windows.h>
#include"DirectDraw.h"
#include"OffObject.h"
#include"DebugUtil.h"

//Names
#define NAME "DirectDrawClass"
#define TITLE "DirectDraw Class Test"
#define DEBUG_FILENAME_MAIN "Main.txt"
#define BMP_FILENAME "test.bmp"

//Globals
CDirectDraw g_DD;
BOOL g_bActive;
CDebugUtil g_debug;

COffObject g_back;
COffObject g_back2;
COffObject g_back3;
COffObject g_back4;
COffObject g_back5;

//COffObject* g_newgame;
//COffObject* g_exit;

//Fucntions
 HRESULT InitApp(HINSTANCE hInstance, int nCmdShow);
 void UpdateFrame();
long FAR PASCAL WindowProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);


int PASCAL
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
LPSTR lpCmdLine, int nCmdShow)
{
	MSG			msg;

	if(InitApp(hInstance, nCmdShow) != DD_OK)
		return FALSE;

	wsprintf(g_debug.ErrMsg,"InitApp Was Passed\n");
	g_debug.ErrFile();

	while(TRUE)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			
			if(!GetMessage(&msg, NULL, 0, 0))
			{ 
				return msg.wParam;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else if(g_bActive)
		{
			UpdateFrame();
		}
		else
		{
			WaitMessage();
		}
	}
	return msg.wParam;
}

void UpdateFrame()
{
//	g_back.PutOff(g_DD.GetDDBack(), 0, 0);
//	g_back2.PutOff(g_DD.GetDDBack(), 30, 30);
//	g_back3.PutOff(g_DD.GetDDBack(), 100,100);
//	g_back4.PutOff(g_DD.GetDDBack(), 150, 120);
	g_back5.PutOff(g_DD.GetDDBack(), 300, 200);
//	wsprintf(g_debug.ErrMsg, "UpdateFrame\n");
//	g_debug.CloseFilePointer();
	g_DD.FilpSurface();
}

 HRESULT InitApp(HINSTANCE hInstance, int nCmdShow)
{
	HWND      hwnd;
	WNDCLASS  wndclass;
//	HRESULT   hRet;
//	DDSURFACEDESC ddsd;

	wndclass.style	=	CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	=	WindowProc;
	wndclass.cbClsExtra		=	0;
	wndclass.cbWndExtra		=	0;
	wndclass.hInstance		=	hInstance;
	wndclass.hIcon			=	LoadIcon(hInstance, IDI_APPLICATION);
	wndclass.hCursor		=	LoadCursor(hInstance, IDC_ARROW);
	wndclass.hbrBackground	=	(HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName	=	NAME;
	wndclass.lpszClassName	=	NAME;
	

	RegisterClass(&wndclass);

	
	hwnd	=	CreateWindowEx(WS_EX_TOPMOST,
		NAME,	
		TITLE,
		WS_POPUP,
		0,
		0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN),
		NULL,
		NULL,
		hInstance,
		NULL);

	

	if(!hwnd)
		return FALSE;
	
	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);
	SetFocus(hwnd);
	
	g_debug.OpenFilePointer(DEBUG_FILENAME_MAIN);
	
	wsprintf(g_debug.ErrMsg,"File Opened\n");
	g_debug.ErrFile();


   g_DD.DirectDrawInit(hwnd, 800, 600, 16);
//	g_back.LoadBmp(g_DD.GetDirectDraw(), "test5.bmp");
//	g_back2.LoadBmp(g_DD.GetDirectDraw(), "exit.bmp");
//	g_back3.LoadBmp(g_DD.GetDirectDraw(), "test.bmp");
//	g_back4.LoadBmp(g_DD.GetDirectDraw(), "mark.bmp");
	g_back5.LoadBmp(g_DD.GetDirectDraw(), "test4.bmp");
	g_bActive = TRUE;
//	g_debug.CloseFilePointer();
	return DD_OK;
}



long FAR PASCAL WindowProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch(iMsg)
	{
	case WM_ACTIVATE:
		//Pause if Minimize
		g_bActive	=	wParam;
		return 0L;
	case WM_DESTROY:
		//Clean up and Close the app
	
		//g_back.Release();
		//g_back2.Release();
		//g_back3.Release();
		//g_back4.Release();
		g_back5.Release();

		g_DD.ReleaseAllObject();
	
		wsprintf(g_debug.ErrMsg,"WM_DESTROY");
		g_debug.ErrFile();
		g_debug.CloseFilePointer();
		

		PostQuitMessage(0);
		return 0L;
	case WM_KEYDOWN:
		switch(wParam)
		{
		case VK_ESCAPE:
		case VK_F12:
	
			PostMessage(hwnd, WM_CLOSE, 0, 0);
			return 0L;
		}
		break;
	case WM_SETCURSOR:
		//Turn off the Cursor since this is a Full-Screen app
		SetCursor(NULL);
		return FALSE;

	}
	return DefWindowProc(hwnd, iMsg, wParam, lParam);
}





