//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
///////////			COffObject							//////////////
//////////////////////////////////////////////////////////////////////
///////////	 2001. 01. 10. wed.							//////////////
//////////									by Donbu    //////////////
//////////////////////////////////////////////////////////////////////

//OffObject.cpp : Implementation of the COffObject Class

#include "OffObject.h"

COffObject::COffObject()
{
	m_pDOSurface = NULL;
	m_pBuf = NULL;
	::ZeroMemory(&m_ddsd, sizeof(m_ddsd));
	m_debug.OpenFilePointer(DEBUG_FILENAME_OFF);
}

COffObject::~COffObject()
{
	m_debug.CloseFilePointer();
	if(m_pDOSurface != NULL)
		Release();
}

COffObject::CreateSurface(LPDIRECTDRAW pdd, int width, int height)
{
	
	wsprintf(m_debug.ErrMsg, "In the CreateSurface..");
	m_debug.ErrFile();
	DDSURFACEDESC ddsd;

	::ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
	ddsd.dwWidth = width;
	ddsd.dwHeight = height;
	
	m_width = width;
	if(height < 0)
		height = -height;
	m_height = height;

	if(FAILED(pdd->CreateSurface(&ddsd, &m_pDOSurface, NULL)))
	{
		wsprintf(m_debug.ErrMsg, "CreateSurface : Creating Error\n");
		m_debug.ErrFile();
		
	}

	//ũ Ʈ üũ
	SearchMaskBit();
	
	//ĮŰ 
	SetColorKey(RGB(255, 0, 0));

	//޸ Ŭ
	ClearSurface();
}

BOOL COffObject::LoadBmp(LPDIRECTDRAW pdd, char* fname)
{
	HFILE				hfile;
	//BITMAPFILEHEADER	bmfh;
	//BITMAPINFOHEADER    bminfo;
//	BYTE *				pDib;
	DWORD				dwSizeImage;
	DWORD               dwImageSize;
	int bfSize;
	int biSize;

	wsprintf(m_debug.ErrMsg, "Starting Loading\n");
	m_debug.ErrFile();



	hfile = _lopen(fname, OF_READ);
	if ( hfile == NULL )
	{
		wsprintf(m_debug.ErrMsg,"Ʈ ȿȽϴ.");
		m_debug.ErrMsgBox();
		return FALSE;
	}
	if ( 
		_lread(hfile, &m_bmfh, sizeof(BITMAPFILEHEADER)) != sizeof(BITMAPFILEHEADER) ||
		m_bmfh.bfType != 0x4d42 
	)
	{
		_lclose(hfile);
		wsprintf(m_debug.ErrMsg,"Ʈ ƴմϴ.");
		m_debug.ErrMsgBox();
		return FALSE;
	}
	
	//  д´.
	_lread(hfile, &m_bminfo, sizeof(BITMAPINFOHEADER));
	
	

	 //׷  뷮ŭ  оδ.
	dwSizeImage = m_bmfh.bfSize - sizeof(BITMAPFILEHEADER) - sizeof(BITMAPINFOHEADER);
	m_pBuf = new BYTE [ dwSizeImage ];

	if ( m_pBuf == NULL )
	{
		wsprintf(m_debug.ErrMsg,"Ʈʷε ۻ.");
		m_debug.ErrMsgBox();
		_lclose(hfile);
		return FALSE;
	}

	if ( _lread(hfile, m_pBuf, dwSizeImage) != dwSizeImage )
	{
		wsprintf(m_debug.ErrMsg,"Ʈʷε ۻ2.");
		m_debug.ErrMsgBox();
		_lclose(hfile);
		delete [] m_pBuf;
		return FALSE;
	}

	dwImageSize = 
		m_bmfh.bfSize - ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	_lclose(hfile);



	// ׷ ε....

	//Create Surface
	CreateSurface(pdd, m_bminfo.biWidth, m_bminfo.biHeight);

	wsprintf(m_debug.ErrMsg, "LoadBmp : biWidth : %d\n",m_bminfo.biWidth);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "LoadBmp : biHeight : %d\n",m_bminfo.biHeight);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "LoadBmp : biBitCount : %d\n",m_bminfo.biBitCount);
	m_debug.ErrFile();

	//Convert Bmp
	m_bminfo.biBitCount = 16;
	//
	Convert24to16();


	

	return TRUE;
}

BOOL COffObject::Convert24to16()
{
	unsigned short r16,g16,b16;
	int Size;
//	int test = -1;
	Size = m_width * m_height;
	PIXEL24 *src = (PIXEL24*) m_pBuf;
	PIXEL16 *dst = (PIXEL16*) new WORD[Size];
	WORD *Temp = (WORD *)dst;
	int Swidth;
	int Sheight;
	int i = 0;

	int x, y;
	wsprintf(m_debug.ErrMsg, "In The Convert24to16 \n");
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "Convert24to16 : Size : %d\n",Size);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "Convert24to16 : dst Pointer : %d\n", dst);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "Convert24to16 : Temp Pointer : %d\n", Temp);
	m_debug.ErrFile();

	for( y = 0; y < m_height; y++)
	{
		for( x = 0; x < m_width; x++ , src++, dst++)
		{
			//555
			if(m_pixelFormat == MODE555)
			{
				r16 = (unsigned short)(src->r / 8 * 1024);
				g16 = (unsigned short)(src->g / 8 * 32);
				b16 = (unsigned short)(src->b / 8);
			}
			//565
			else if(m_pixelFormat == MODE565)
			{
				r16 = (unsigned short)(src->r / 8 * 2048);
				g16 = (unsigned short)(src->g / 4 * 32);
				b16 = (unsigned short)(src->b / 8);
		

				wsprintf(m_debug.ErrMsg, "R: %d G: %d B : %d\n",src->r, src->g, src->b);
				m_debug.ErrFile();	
			}
				
				
				
			dst->color	=	r16&m_redMaskbit | g16&m_greenMaskbit | b16&m_blueMaskbit;

			wsprintf(m_debug.ErrMsg, "dst color : %d\n",dst->color);
			m_debug.ErrFile();	

		}
		wsprintf(m_debug.ErrMsg, "\n");
		m_debug.ErrFile();
	}

	delete m_pBuf;	

	//SaveBmp(Temp);
	//Locking... ͸ OffScreen Է
	WORD* surface = Lock();
	
	Swidth = (long)m_ddsd.dwWidth;
	Sheight = (long)m_ddsd.dwHeight;


	for(y = 0; y < Sheight ; y++)
		for(x = 0; x < Swidth; x++)
		{
			surface[x +  y * Swidth]
					=	Temp[x + (y) * (m_width)];

		}
	
	UnLock();
	
	wsprintf(m_debug.ErrMsg, "Convert24to16 : dwHeight : %d\n",Swidth);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "Convert24to16 : dwWidth : %d\n",Sheight);
	m_debug.ErrFile();
	wsprintf(m_debug.ErrMsg, "Convert24to16 : m_width : %d\n",m_width);
	m_debug.ErrFile();	

	
	return TRUE;
}

WORD* COffObject::Lock()
{
	::ZeroMemory(&m_ddsd, sizeof(m_ddsd));
	m_ddsd.dwSize = sizeof(m_ddsd);

	m_pDOSurface->Lock(NULL, &m_ddsd, DDLOCK_WAIT, NULL);

	return (WORD* )m_ddsd.lpSurface;
}

void COffObject::UnLock()
{
	m_pDOSurface->Unlock(NULL);
}

COffObject::SetColorKey(COLORREF rgb)
{
	wsprintf(m_debug.ErrMsg, "In the SetColorKey\n");
	m_debug.ErrFile();

	DDCOLORKEY ddck;

	ddck.dwColorSpaceLowValue = ColorMatch(rgb);
	ddck.dwColorSpaceHighValue = ddck.dwColorSpaceLowValue;

	wsprintf(m_debug.ErrMsg, "SetColorKey : ColorKey : %d\n",ddck.dwColorSpaceHighValue);
	m_debug.ErrFile();
	m_pDOSurface->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

DWORD COffObject::ColorMatch(COLORREF rgb)
{
	COLORREF rgbT;
    HDC hdc;
    DWORD dw = CLR_INVALID;
    DDSURFACEDESC ddsd;
    HRESULT hres;

	wsprintf(m_debug.ErrMsg, "In the ColorMatch\n");
	m_debug.ErrFile();

    //  use GDI SetPixel to color match for us
    if (rgb != CLR_INVALID && m_pDOSurface->GetDC(&hdc) == DD_OK)
    {
		rgbT = ::GetPixel(hdc, 0, 0);								// save current pixel value
		::SetPixel(hdc, 0, 0, rgb);									// set our value
		m_pDOSurface->ReleaseDC(hdc);
    }

    // now lock the surface so we can read back the converted color
    ddsd.dwSize = sizeof(ddsd);
    while ((hres = m_pDOSurface->Lock(NULL, &ddsd, 0, NULL)) == DDERR_WASSTILLDRAWING);

    if (hres == DD_OK)
    {
		dw  = *(DWORD *)ddsd.lpSurface;								// get DWORD
	     if(ddsd.ddpfPixelFormat.dwRGBBitCount < 32)
	         dw &= (1 << ddsd.ddpfPixelFormat.dwRGBBitCount)-1;		// mask it to bpp
		m_pDOSurface->Unlock(NULL);
    }

    //  now put the color that was there back.
    if (rgb != CLR_INVALID && m_pDOSurface->GetDC(&hdc) == DD_OK)
    {
		::SetPixel(hdc, 0, 0, rgbT);
		m_pDOSurface->ReleaseDC(hdc);
    }

    return dw;
}

COffObject::ClearSurface()
{
	wsprintf(m_debug.ErrMsg, "In the ClearSurface");
	m_debug.ErrFile();
}

COffObject::PutOff(LPDIRECTDRAWSURFACE pSurface, int x, int y)
{
	HRESULT hRet;
	hRet = pSurface->BltFast(x, y, m_pDOSurface, NULL, DDBLTFAST_SRCCOLORKEY | 
		              DDBLTFAST_WAIT);
    if(hRet != DD_OK)
	{
		wsprintf(m_debug.ErrMsg, "PutOff Error");
		m_debug.ErrFile();
		m_debug.ErrMsgBox();
		
	}

}

COffObject::GetImage(LPDIRECTDRAWSURFACE pSurface, int x, int y, int w,
					 int h)
{

}


void COffObject::SearchMaskBit()
{
	HRESULT		hr;
	wsprintf(m_debug.ErrMsg, "In the SearchMaskBit\n");
	m_debug.ErrFile();

	::ZeroMemory(&this->m_ddsd, sizeof(this->m_ddsd));
	this->m_ddsd.dwSize		= sizeof( this->m_ddsd );
    this->m_ddsd.dwFlags	= DDSD_PIXELFORMAT;

    hr = m_pDOSurface->GetSurfaceDesc(&this->m_ddsd);


    if(hr == DD_OK)
	{
		if (this->m_ddsd.ddpfPixelFormat.dwRBitMask == 0xF800) 
		{
			this->m_pixelFormat		=	MODE565;

			m_redMaskbit = 0xf800;
			m_greenMaskbit = 0x07e0;
			m_blueMaskbit = 0x001f;
			
			wsprintf(m_debug.ErrMsg, "SearchMaskBit : MODE%d\n",MODE565);
			m_debug.ErrFile();

		}
		if (this->m_ddsd.ddpfPixelFormat.dwRBitMask == 0x7C00) 
		{
			this->m_pixelFormat		=	MODE555;

			m_redMaskbit = 0x7c00;
			m_greenMaskbit = 0x03e0;
			m_blueMaskbit = 0x001f;

			wsprintf(m_debug.ErrMsg, "SearchMaskBit : MODE%d\n",MODE555);
			m_debug.ErrFile();
		}
	}
}

COffObject::Release()
{
	if(m_pDOSurface != NULL)
	{
		m_pDOSurface->Release();
		m_pDOSurface = NULL;
	}
}


int COffObject::GetWidth()
{
	return m_width;
}

int COffObject::GetHeight()
{
	return m_height;
}

BOOL COffObject::SaveBmp(WORD* data)
{
	HFILE				hfile;
	hfile = _lcreat("AB.bmp",0 );

	
    _lwrite(hfile,(LPCSTR) &m_bmfh, sizeof(m_bmfh)); 
	_lwrite(hfile,(LPCSTR) &m_bminfo, sizeof(m_bminfo));
	_lwrite(hfile,(LPCSTR) &data, m_bminfo.biWidth * m_bminfo.biHeight * 16);
	
	_lclose(hfile);

	return TRUE;
}