//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//        COffObject Class							//////////////////
//													//////////////////
//  2001. 01. 10     wed                            //////////////////
//								by Donbu            //////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

//OffObject.h
#ifndef _OFFOBJECT_H_
#define _OFFOBJECT_H_

//Includes
#include<ddraw.h>
#include"DebugUtil.h"

#define DEBUG_FILENAME_OFF "OffObject.txt"

#define MODE555		555
#define MODE565		565

typedef struct
{
	unsigned char b, g, r;
}PIXEL24;

typedef struct
{
	unsigned short color;
}PIXEL16;


class COffObject
{
public:

	LPDIRECTDRAWSURFACE m_pDOSurface;
	int m_width;
	int m_height;
	COLORREF m_ColorKey; //Default RGB(255, 0, 0)
	DDSURFACEDESC m_ddsd;
	BYTE* m_pBuf;

	WORD m_pixelFormat;
	WORD m_redMaskbit;
	WORD m_greenMaskbit;
	WORD m_blueMaskbit;

	int m_redShiftbit;
	int m_greenShiftbit;
	int m_blueShiftbit;

	CDebugUtil m_debug;
public:
	BITMAPINFOHEADER m_bminfo;
	BITMAPFILEHEADER m_bmfh;
	COffObject();
	~COffObject();
	CreateSurface(LPDIRECTDRAW pdd, int width, int height);
	ClearSurface(); // n/a
	Release();
	BOOL LoadBmp(LPDIRECTDRAW pdd, char* fname);
	BOOL SaveBmp(WORD* data);
	BOOL Convert24to16();
	SetColorKey(COLORREF rgb);
	PutOff(LPDIRECTDRAWSURFACE pSurface, int x, int y);
	GetImage(LPDIRECTDRAWSURFACE pSurface, int x, int y, int w, int h);
	DWORD ColorMatch(COLORREF rgb);
	void SearchMaskBit();
	WORD* Lock();
	void UnLock();

	int GetWidth();
	int GetHeight();

};


#endif