/////////////////////////////////////////////////////////////////////
//	
//	Dib.cpp
//
//	Thrunet Game Development Forum X-Team Programmer
//	yeong min, hong. (kbdyj@thrunet.com)
//
//	General DIB Management class
//
/////////////////////////////////////////////////////////////////////	


#include <stdafx.h>
#include "Dib.h"

//-------------------------------------------------------------------
//	Constructor & Destructor
//-------------------------------------------------------------------

CDib::CDib()
{
	m_bInstalled = FALSE;
	m_lpBmih = NULL;
	m_lpDib = NULL;
	m_lpImage = NULL;
	m_lpPalette = NULL;
	m_nNumPalette = 0;
}

CDib::~CDib()
{
	Flush();
}

//-------------------------------------------------------------------
//	Load 
//-------------------------------------------------------------------

BOOL
CDib::Load (LPCTSTR szFileName)
{
	HFILE				hfile;
	BITMAPFILEHEADER	bmfh;
	BYTE *				pDib;
	DWORD				dwSizeDib;
	int					nNumPalette;

	hfile = _lopen(szFileName, OF_READ);
	if ( hfile == NULL )
		return FALSE;

	if ( 
		_lread(hfile, &bmfh, sizeof(BITMAPFILEHEADER)) != sizeof(BITMAPFILEHEADER) ||
		bmfh.bfType != 0x4d42 
	)
	{
		_lclose(hfile);
		return FALSE;
	}

	dwSizeDib = bmfh.bfSize - sizeof(BITMAPFILEHEADER);
	pDib = new BYTE [ dwSizeDib ];
	if ( pDib == NULL )
	{
		_lclose(hfile);
		return FALSE;
	}

	if ( _lread(hfile, pDib, dwSizeDib) != dwSizeDib )
	{
		_lclose(hfile);
		delete [] pDib;
		return FALSE;
	}

	m_lpBmih = (BITMAPINFOHEADER *) pDib;
	m_lpDib = pDib;
	
	nNumPalette = GetNumPalette();

	m_lpPalette = (RGBQUAD *) ( m_lpDib + sizeof(BITMAPINFOHEADER) );
	m_lpImage = (BYTE *) ( m_lpPalette + nNumPalette);
	m_bInstalled = TRUE;
	m_dwImageSize = 
		bmfh.bfSize - ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + nNumPalette * sizeof(RGBQUAD) );

	_lclose(hfile);

	return TRUE;
}

//-------------------------------------------------------------------
//	Flush
//-------------------------------------------------------------------

void
CDib::Flush (void)
{
	if ( m_lpDib )
	{
		delete [] m_lpDib;
		m_lpDib = NULL;
	}

	m_bInstalled = FALSE;
	m_nNumPalette = 0;
}

//-------------------------------------------------------------------
//	GetWidth
//-------------------------------------------------------------------

LONG
CDib::GetWidth (void)
{


	return m_lpBmih->biWidth;
}

//-------------------------------------------------------------------
//	GetHeight
//-------------------------------------------------------------------

LONG
CDib::GetHeight (void)
{


	return m_lpBmih->biHeight;
}

//-------------------------------------------------------------------
//	GetNumPalette
//-------------------------------------------------------------------

int
CDib::GetNumPalette (void)
{
	int	nNumPalette;



	if ( m_lpBmih->biBitCount > 8 )
		return 0;

	nNumPalette = m_lpBmih->biClrUsed;

	if ( nNumPalette == 0 || m_lpBmih->biBitCount <= 8 )
		nNumPalette = 1 << m_lpBmih->biBitCount;

	return nNumPalette;
}

//-------------------------------------------------------------------
//	GetImageSize
//-------------------------------------------------------------------

DWORD
CDib::GetImageSize (void)
{

	return m_dwImageSize;
}

//-------------------------------------------------------------------
//	GetBitmapInfo
//-------------------------------------------------------------------

BITMAPINFO *
CDib::GetBitmapInfoPtr (void)
{
	return (BITMAPINFO *) m_lpDib;
}

void CDib::Create(int cx, int cy, int bpp)
{
	int bytes; 
	int need_mem;
	int Size;

	if(bpp <= 8)
	{
		m_nNumPalette = 1 << bpp;
	}
	else
	{
		m_nNumPalette = 0;
	}

	bytes = cx * cy * (bpp / 8);
	need_mem = sizeof(BITMAPINFOHEADER)
				+ sizeof(RGBQUAD) * m_nNumPalette
				+ bytes;
	m_lpDib	 = (BYTE*)malloc(need_mem);
	if(m_lpDib == NULL)
	{
		return;
	}

	m_lpBmih = (LPBITMAPINFOHEADER)m_lpDib;
	m_lpBmih->biSize		=	sizeof(BITMAPINFOHEADER);
	m_lpBmih->biWidth		=	cx;
	m_lpBmih->biHeight		=	cy;
	m_lpBmih->biPlanes		=	1;
	m_lpBmih->biBitCount	=	bpp;
	m_lpBmih->biCompression	=	BI_RGB;
	m_lpBmih->biSizeImage	=	0;
	m_lpBmih->biXPelsPerMeter	=	0;
	m_lpBmih->biYPelsPerMeter	=	0;
	m_lpBmih->biClrUsed			=	0;
	m_lpBmih->biClrImportant	=	0;

	m_lpImage = (BYTE*)(m_lpDib + sizeof(BITMAPINFOHEADER)
				+ (sizeof(RGBQUAD) * m_nNumPalette));

	//ȷƮ  ()
	RedMask = 0x7c00;
	GreenMask = 0x03e0;
	BlueMask  = 0x001f;	
	BitMode = MODE555;
	return;
}

void CDib::SetBitMode(int mode)
{
	BitMode = mode;
	
	switch(BitMode)
	{
	case MODE555:
		RedMask = 0x7c00;
		GreenMask = 0x03e0;
		BlueMask  = 0x001f;	
		break;
	case MODE565:
		RedMask	= 0xf800;
		GreenMask = 0x07e0;
		BlueMask  = 0x001f;
		break;
	}

}

BOOL CDib::Convert24To16(CDib *pDib)
{
	unsigned short r16,g16,b16;
	PIXEL24 *src = (PIXEL24*)pDib->GetImagePtr();
	PIXEL16 *dst = (PIXEL16*)GetImagePtr();
	for(int k = 0; k < pDib->GetHeight(); k++)
	{
		for(int j = 0; j < pDib->GetWidth(); j++ , src++, dst++)
		{
			//555
			if(BitMode == MODE555)
			{
				r16 = (unsigned short)(src->r / 8 * 1024);
				g16 = (unsigned short)(src->g / 8 * 32);
				b16 = (unsigned short)(src->b / 8);
			}
			//565
			else if(BitMode == MODE565)
			{
				r16 = (unsigned short)(src->r / 8 * 512);
				g16 = (unsigned short)(src->g / 8 * 32);
				b16 = (unsigned short)(src->b / 8);
			}

			dst->color	=	r16&RedMask | g16&GreenMask | b16&BlueMask;

		}
	}
	
	m_bInstalled = TRUE;

	return TRUE;
}

