/////////////////////////////////////////////////////////////////////
//	
//	Dib.h
//
//	Thrunet Game Development Forum X-Team Programmer
//	yeong min, hong. (kbdyj@thrunet.com)
//
//	General DIB Management class
//
/////////////////////////////////////////////////////////////////////

//Defines
#define MODE555		555
#define MODE565		565

typedef struct
{
	unsigned char b, g, r;
}PIXEL24;

typedef struct
{
	unsigned short color;
}PIXEL16;

//-------------------------------------------------------------------
//	CDib 
//-------------------------------------------------------------------

class CDib  
{
	public:
		BITMAPINFOHEADER *	m_lpBmih;
		RGBQUAD *     		m_lpPalette;
		BYTE *				m_lpDib;
		BYTE *				m_lpImage;
		BOOL				m_bInstalled;

	public:
		BOOL Convert24To16(CDib* pDib);
		void SetBitMode(int mode);
		void Create(int cx, int cy, int bpp);
		int BitMode;
		WORD BlueMask;
		WORD GreenMask;
		WORD RedMask;
		DWORD m_dwImageSize;
		int m_nNumPalette;

		CDib();
		virtual ~CDib();

		BOOL				Load (LPCTSTR szFileName);
		void				Flush (void);
		
		int					GetNumPalette (void);
		LONG				GetWidth (void);
		LONG				GetHeight (void);
		DWORD				GetImageSize (void);
		BITMAPINFO *		GetBitmapInfoPtr (void);

		BYTE *				GetImagePtr (void)		{ return m_lpImage;		}
		RGBQUAD *     		GetPalettePtr (void)	{ return m_lpPalette;	}
		BOOL				IsInstalled (void)		{ return m_bInstalled;	}
};


