#include <Winsock2.h>

#include <windows.h>
#include <stdlib.h>

#include <stdlib.h>
#include "resource.h"
#define PACKET_SIZE  100
#define WM_ASYNC     	(WM_USER + 1)
#define PORT_NUMBER	10000
#define SERVER_ADDR	"127.0.0.1"

//#define SERVER_ADDR		"127.0.0.1"//.....localhost̴..  ǻͿ  ִٸ ̰͸ ൵ ȴ.. Ǹ  ʿ䰡 .
BOOL CALLBACK HandleDialog(HWND, UINT, WPARAM, LPARAM);

LRESULT  CALLBACK  EditProc(HWND  hWnd,  UINT  msg,  WPARAM  wParam, LPARAM lParam);

BOOL InitSocket(HWND hWnd);




WNDPROC 		OldProc;
char 		msg[PACKET_SIZE];

SOCKET 		m_s;
SOCKADDR_IN 	m_addr;
IN_ADDR 		m_in;
HWND 		hParent;

/*---------------------------------------------------------------------------------------------------------------
	WinMain()                                                            
-----------------------------------------------------------------------------------------------------------------*/
int PASCAL   WinMain(HINSTANCE hInstance,  HINSTANCE hPrevInstance,  LPSTR lpCmdLine, int nCmdShow) 
{
	HWND         hWnd;
	MSG           msg;
	
	/* --------------------------- ̾α ڽ  --------------------------- */
	if((hWnd = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_CLIENT), NULL, HandleDialog)) == NULL) 
	{
		MessageBox(hWnd, "Initialize Error", "Ȯ", MB_OK);
		return FALSE;
	}
	hParent = hWnd;
	/* --------------------------- ޽  --------------------------- */
	while(GetMessage(&msg, NULL, 0, 0)) {
		if(!IsDialogMessage(hWnd, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return msg.wParam;
}

/*---------------------------------------------------------------------------------------------------------------
	HandleDialog()                                                        
-----------------------------------------------------------------------------------------------------------------*/
BOOL  CALLBACK  HandleDialog(HWND  hWnd,  UINT  iMsg,  WPARAM wParam, LPARAM lParam) 
{
	HWND hListBox;
	char msgInfo[60];

	switch(iMsg) 
	{
	   /* --------------------------- ̾α ڽ  ޽ --------------------------- */
	   case WM_INITDIALOG:
           memset(msg, '\0', sizeof(msg));
           if(!InitSocket(hWnd))
                return FALSE;
	       OldProc = (WNDPROC) SetWindowLong (GetDlgItem(hWnd,IDC_EDIT), GWL_WNDPROC, (LONG)EditProc);
           return TRUE;
	   /* ---------------------------   ޽ --------------------------- */
	   case WM_DESTROY:
	       PostQuitMessage(0);
	       return TRUE;
	   /* --------------------------- "" ư   --------------------------- */
	   case WM_COMMAND:
		switch(wParam) 
		{
			case IDC_EXIT:

			   closesocket(m_s);
			   m_s = INVALID_SOCKET;
			   WSACleanup();
			   DestroyWindow(hWnd);
			   return TRUE;
		}
		break;
	   /* --------------------------- 񵿱 ޽ ó --------------------------- */
	   case WM_ASYNC:
			hListBox = GetDlgItem(hWnd, IDC_LIST);

			switch(WSAGETSELECTEVENT(lParam)) 
			{
			/* --------------------------- û ޽ --------------------------- */	
			   case FD_CONNECT:
			    	wsprintf(msgInfo, "Ǿϴ. ");
				    SendMessage(hListBox, LB_INSERTSTRING, 0, (LPARAM)msgInfo);
				if(WSAAsyncSelect(m_s, hWnd, WM_ASYNC, FD_READ|FD_WRITE|FD_CLOSE) == SOCKET_ERROR)   
				{
					wsprintf(msgInfo, "Async Select Ҽ . ");
					SendMessage(hListBox, LB_INSERTSTRING, 0 , (LPARAM)msgInfo);
					return FALSE;
				}
				break;
		/* ---------------------------   ޽ --------------------------- */
	   case FD_CLOSE:
			closesocket(m_s);
			m_s = INVALID_SOCKET;
			wsprintf(msgInfo, "  ϴ.");
			SendMessage(hListBox, LB_INSERTSTRING, 0, (LPARAM)msgInfo);
			WSACleanup();
			break;
		/* ---------------------------  ۽ ޽ ---------------------------*/
		case FD_WRITE:						
			send(m_s, msg, sizeof(msg), 0);
			memset(msg, '\0', sizeof(msg));
			break;
		/* ---------------------------   ޽ ---------------------------*/
		case FD_READ:
			{
				int recv_len = 0;
				int total_len = 0;
				memset(msg, '\0', sizeof(msg));
			    while(total_len < 100)
				{
					recv_len = recv(m_s, msg, sizeof(msg), 0);
					total_len = total_len + recv_len;
				}
				//MessageBox(hWnd, msg, "client" , MB_OK);
					SendMessage(hListBox, LB_INSERTSTRING, 0,
						(LPARAM)msg);
				break;
			}
		default:
			break;
		}
		return 0L;
	}
	return FALSE;
}

/*---------------------------------------------------------------------------------------------------------------
	EditProc(),   ν                                        
-----------------------------------------------------------------------------------------------------------------*/
LRESULT  CALLBACK  EditProc(HWND  hWnd,  UINT  iMsg,  WPARAM
				  wParam, LPARAM lParam) 
{
	
	switch(iMsg) 
	{ 
	case WM_CHAR:
		if(wParam == VK_RETURN) 
		{
			GetWindowText(hWnd, (LPTSTR)msg, sizeof(msg));
			PostMessage(hParent, WM_ASYNC, m_s,
				      WSAMAKESELECTREPLY(FD_WRITE, 0));
			SetWindowText(hWnd, "");
			break;
		}
	}

	
	return CallWindowProc(OldProc, hWnd, iMsg, wParam, lParam);
}

/*---------------------------------------------------------------------------------------------------------------
	InitSocket(),   Լ                                           
-----------------------------------------------------------------------------------------------------------------*/
BOOL InitSocket(HWND hWnd) 
{
	WORD wVersionRequested = MAKEWORD(1, 1);
	WSADATA wsaData;
	int nError;

	nError = WSAStartup(wVersionRequested, &wsaData);
	
	if(nError != 0) 
	{
		MessageBox(hWnd, " ʱȭ ", "Ȯ", MB_OK);
		return FALSE;
	}

	m_s = socket(AF_INET, SOCK_STREAM, 0);
	if(m_s == INVALID_SOCKET) 
	{
		MessageBox(hWnd, "ϻ  ", "Ȯ", MB_OK);
		return FALSE;
	}
	else
	{
		m_addr.sin_family = AF_INET;
		m_addr.sin_port = htons(PORT_NUMBER);   
		m_addr.sin_addr.s_addr = inet_addr(SERVER_ADDR);
	
		if(WSAAsyncSelect(m_s, hWnd, WM_ASYNC, FD_CONNECT) == SOCKET_ERROR) 
		{
			MessageBox(hWnd, " ", "Ȯ", MB_OK);
			return FALSE;
		}
		else 
		{
			if(connect(m_s, (LPSOCKADDR)&m_addr,  
			sizeof(m_addr)) == SOCKET_ERROR) 
			{
			   if(WSAGetLastError() != WSAEWOULDBLOCK) 
			   {
			      MessageBox(hWnd, " ", "Ȯ", MB_OK);
		 	      return FALSE;
			   }
			}
		}
	}//else
	return TRUE;
}
