#include <Winsock2.h>
#include <windows.h>
#include <stdlib.h>
#include <process.h>
#include <stdlib.h>
#include "resource.h"
#define PACKET_SIZE  100
#define SERVER_ADDR	"127.0.0.1"
#define PORT 10000
#define DATA_BUFSIZE 100
#define MAX_CLIENT    50

typedef struct
{
   OVERLAPPED Overlapped;
   WSABUF     DataBuf;
   DWORD      BytesTrans;
   char       Buffer[DATA_BUFSIZE];   
   int        IOState;//0 recv 1 send
} PER_IO_OPERATION_DATA, *LPPER_IO_OPERATION_DATA;



typedef struct 
{
   SOCKET Socket;
   int client_i;    
   bool Socket_State;
} PER_HANDLE_DATA, * LPPER_HANDLE_DATA;//port key



PER_HANDLE_DATA                  g_PerHandleData;
PER_IO_OPERATION_DATA            g_PerIOData[2];//0 recv 1 send

void ServerWorkerThread(void* CompletionPortID);
BOOL CALLBACK HandleDialog(HWND, UINT, WPARAM, LPARAM);
LRESULT  CALLBACK  EditProc(HWND  hWnd,  UINT  msg,  WPARAM  wParam, LPARAM lParam);
BOOL InitSocket(HWND hWnd);
void DataAnalysis(HANDLE CompletionPort, LPPER_HANDLE_DATA lPerHandleData ,LPPER_IO_OPERATION_DATA lPerIOData , int ThreadID);



WNDPROC 		OldProc;
char 		msg[PACKET_SIZE];

SOCKET 		g_ConnectSocket;
SOCKADDR_IN 	m_addr;
IN_ADDR 		m_in;
HWND 		g_hListBox;
HWND        g_hWnd;
HANDLE g_CompletionPort; //cpio


/*---------------------------------------------------------------------------------------------------------------
	WinMain()                                                            
-----------------------------------------------------------------------------------------------------------------*/
int PASCAL   WinMain(HINSTANCE hInstance,  HINSTANCE hPrevInstance,  LPSTR lpCmdLine, int nCmdShow) 
{
	HWND         hWnd;
	MSG           msg;
	
	/* --------------------------- ̾α ڽ  --------------------------- */
	if((hWnd = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_CLIENT), NULL, HandleDialog)) == NULL) 
	{
		MessageBox(hWnd, "Initialize Error", "Ȯ", MB_OK);
		return FALSE;
	}

	/* --------------------------- ޽  --------------------------- */
	while(GetMessage(&msg, NULL, 0, 0)) {
		if(!IsDialogMessage(hWnd, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return msg.wParam;
}

/*---------------------------------------------------------------------------------------------------------------
	HandleDialog()                                                        
-----------------------------------------------------------------------------------------------------------------*/
BOOL  CALLBACK  HandleDialog(HWND  hWnd,  UINT  iMsg,  WPARAM wParam, LPARAM lParam) 
{
	switch(iMsg) 
	{
		   /* --------------------------- ̾α ڽ  ޽ --------------------------- */
		   case WM_INITDIALOG:
			   g_hWnd = hWnd;
			   g_hListBox = GetDlgItem(hWnd,IDC_LIST);

			   if(!InitSocket(hWnd))
					return FALSE;

			   OldProc = (WNDPROC) SetWindowLong (GetDlgItem(hWnd,IDC_EDIT), GWL_WNDPROC, (LONG)EditProc);
			   return TRUE;
		   /* ---------------------------   ޽ --------------------------- */
		   case WM_DESTROY:
			   PostQuitMessage(0);
			   return TRUE;
		   /* --------------------------- "" ư   --------------------------- */
		   case WM_COMMAND:
			   switch(wParam) 
			   {
					case IDC_EXIT:
                       g_hWnd = hWnd;
					   
					   closesocket(g_PerHandleData.Socket);
					   //g_PerHandleData.Socket = INVALID_SOCKET;
					   //WSACleanup();
					   //PostQueuedCompletionStatus(g_CompletionPort , 0 , (DWORD)&g_PerHandleData , (LPOVERLAPPED )&g_PerIOData[1] );
                      
					   //Sleep(10);
					   DestroyWindow(g_hWnd);
					   return TRUE;
			   }//switch(wParam) 
			   break;
		   /* --------------------------- 񵿱 ޽ ó --------------------------- */
		
		   default:
				break;
	
	}//switch(iMsg) 
	return FALSE;
}//BOOL  CALLBACK  HandleDialog()




/*---------------------------------------------------------------------------------------------------------------
	EditProc(),   ν                                        
-----------------------------------------------------------------------------------------------------------------*/
LRESULT  CALLBACK  EditProc(HWND  hWnd,  UINT  iMsg,  WPARAM
				  wParam, LPARAM lParam) 
{
	char tBuf[100] = {0,};
	char Send_Buf[100]={0,};	
	DWORD SendBytes = 0;
	switch(iMsg) 
	{ 
	case WM_CHAR:
		if(wParam == VK_RETURN) 
		{
			GetWindowText(hWnd, (LPTSTR)Send_Buf, sizeof(Send_Buf));		
			SetWindowText(hWnd, "");
			//////////sendϴ ƾ/////////////////////////////
			if(g_PerHandleData.Socket_State == true)
			{
				memcpy(g_PerIOData[1].Buffer , Send_Buf , sizeof(Send_Buf)  );				   
				ZeroMemory(&(g_PerIOData[1].Overlapped), sizeof(OVERLAPPED));
				g_PerIOData[1].DataBuf.buf = g_PerIOData[1].Buffer ;//  κ   .
				g_PerIOData[1].DataBuf.len = sizeof(g_PerIOData[1].Buffer);// Ʈ  Ѵ.

  				if (WSASend(g_PerHandleData.Socket , &(g_PerIOData[1].DataBuf), 1, &SendBytes, 0,         
									&(g_PerIOData[1].Overlapped), NULL) == SOCKET_ERROR)// ⿡ PerHandleData  Ʈ  Ǿ ˼ ٰ ص, CreateIoCompletionPort() Ư Ʈ  ־.
				  {
					   if (WSAGetLastError() != ERROR_IO_PENDING)
					   {
							wsprintf(tBuf, "WSASend() failed with error %d in EditProc()", WSAGetLastError());
                            MessageBox(NULL, tBuf , "Ȯ", MB_OK);							
					   }
				  }				
			}//if(g_PerHandleData[i].Socket_State == true)
			////////// sendϴ ƾ̾ϴ./////////
			break;
		}//if(wParam == VK_RETURN) 
	}
	
	return CallWindowProc(OldProc, hWnd, iMsg, wParam, lParam);
}

/*---------------------------------------------------------------------------------------------------------------
	InitSocket(),   Լ                                           
-----------------------------------------------------------------------------------------------------------------*/
BOOL InitSocket(HWND hWnd) 
{
	char tBuf[DATA_BUFSIZE]={0,};
	WORD wVersionRequested = MAKEWORD(1, 1);
	WSADATA wsaData;
	int nError;

	nError = WSAStartup(wVersionRequested, &wsaData);
	
	if(nError != 0) 
	{
		MessageBox(g_hWnd, " ʱȭ ", "Client", MB_OK);
		return FALSE;
	}
    //////////cpio ƾ///////////////////// 
    //Setup an I/O completion port.  
    if ((g_CompletionPort = CreateIoCompletionPort(INVALID_HANDLE_VALUE, NULL, 0, 0)) == NULL)
    {
       wsprintf(tBuf, "CreateIoCompletionPort failed with error: %d", GetLastError());
	   MessageBox(g_hWnd, tBuf, "Client", MB_OK);
       return FALSE;
    }
    // Determine how many processors are on the system.
    SYSTEM_INFO SystemInfo;
    GetSystemInfo(&SystemInfo);

    // Create worker threads based on the number of processors available on the
    // system. Create two worker threads for each processor.
    // ýۿ 밡 ŭ μ * 2  ....ٵ  2?
    for(int i = 0; i < (signed)SystemInfo.dwNumberOfProcessors  ; i++)
    {
      unsigned long ThreadHandle;
      // Create a server worker thread and pass the completion port to the thread.

      if( (ThreadHandle = _beginthread(ServerWorkerThread , 0, (void*)i ) )== 0)
	  {
         wsprintf(tBuf, "_beginthread() failed with error %d\n", GetLastError());
         MessageBox(g_hWnd, tBuf, "Client", MB_OK);
         return FALSE;
	  }  
    }


	///////// cpio ƾ/////////////////////
	g_PerHandleData.Socket = socket(AF_INET, SOCK_STREAM, 0);
	g_PerHandleData.client_i = 1;
	g_PerHandleData.Socket_State = true;

	if(g_PerHandleData.Socket == INVALID_SOCKET) 
	{
		MessageBox(g_hWnd , "g_PerHandleData.Socketϻ  ", "Client", MB_OK);
		return FALSE;
	}

	m_addr.sin_family = AF_INET;
	m_addr.sin_port = htons(PORT);   
	m_addr.sin_addr.s_addr = inet_addr(SERVER_ADDR);

	if (CreateIoCompletionPort((HANDLE)g_PerHandleData.Socket , g_CompletionPort, (DWORD) &g_PerHandleData , 0) == NULL)
	{
		 wsprintf(tBuf, "CreateIoCompletionPort failed with error %d\n", GetLastError());
		 MessageBox(g_hWnd , tBuf , "Client", MB_OK);
		 return FALSE;
	} 


	if(connect(g_PerHandleData.Socket, (LPSOCKADDR)&m_addr,  sizeof(m_addr)) == SOCKET_ERROR) 
	{
	   if(WSAGetLastError() != WSAEWOULDBLOCK) 
	   {
          wsprintf(tBuf, "Connect Error %d" , GetLastError() );
	      MessageBox(g_hWnd, tBuf, "Client"	  , MB_OK);
	      return FALSE;
	   }
	}	

    ////////////////////recv غ////////////////
    g_PerIOData[0].IOState = 0;     	  
	g_PerIOData[1].IOState = 1;//.
    ZeroMemory( &(g_PerIOData[0].Overlapped), sizeof(OVERLAPPED)  );   
    g_PerIOData[0].BytesTrans = 0;
    g_PerIOData[0].DataBuf.len = DATA_BUFSIZE;
    g_PerIOData[0].DataBuf.buf = g_PerIOData[0].Buffer;
    DWORD Flags = 0;
	DWORD RecvBytes = 0;
    //g_PerHandleData g_PerIData  Ÿ workerThread  ټ ִ.
    if (WSARecv( g_PerHandleData.Socket , &(g_PerIOData[0].DataBuf), 1, &RecvBytes, &Flags,//Flags = 0
                                                   &(g_PerIOData[0].Overlapped), NULL) == SOCKET_ERROR)
    {
       if (WSAGetLastError() != ERROR_IO_PENDING)
       {
          wsprintf(tBuf, "WSARecv() failed with error %d in InitSocket ", WSAGetLastError());
		  MessageBox(g_hWnd, tBuf  , "Client" , MB_OK);
          return FALSE;
       }
    }//if (WSARecv(A
     

	return TRUE;
}





void ServerWorkerThread(void* temp)
{
   char tBuf[100]={0,};
   int ThreadID;
   HANDLE CompletionPort = g_CompletionPort;
   DWORD lBytesTransferred;
   LPPER_IO_OPERATION_DATA lPerIOData;
   LPPER_HANDLE_DATA lPerHandleData;
   DWORD RecvBytes;
   
   ThreadID = (int)temp;
   while(1)
   {
	   //WSARecv Ϸɶ , ̺Ʈ߻Ų ϰ Ʈȯ
   	   if (GetQueuedCompletionStatus(CompletionPort, &lBytesTransferred,
                                             (LPDWORD)&lPerHandleData, (LPOVERLAPPED *) &lPerIOData, INFINITE) == 0)
       {
            wsprintf(tBuf , "GetQueuedCompletionStatus failed with error %d\n", GetLastError());
            MessageBox(g_hWnd , tBuf , "iocp_Client", MB_OK);
			return ;
       }
	   //closesocket() ó
       if(lBytesTransferred == 0)
       {
           wsprintf(tBuf, "Closing socket %d\n"  , lPerHandleData->Socket);

           if (closesocket(lPerHandleData->Socket) == SOCKET_ERROR)
		   {
              if(GetLastError() == 10038)
			  {
				  continue;
			  }
			  else
			  {
				wsprintf(tBuf , "closesocket() failed with error %d\n", WSAGetLastError());
				MessageBox(g_hWnd , tBuf , "iocp_Client", MB_OK);
                return ;
			  }
		   }		   
		   wsprintf(tBuf , "%dϿ ϴ." , lPerHandleData->Socket );		
		   SendMessage(g_hListBox, LB_INSERTSTRING, 0, (LPARAM)tBuf);
		   lPerHandleData->Socket_State = false;
           DestroyWindow(g_hWnd);

		   _endthread();
		   
           //GlobalFree(lPerHandleData);// malloc ߴ GetQueuedCompletionStatus Ÿ Է¹鼭 ޸𸮰 Ҵȴ.
           //GlobalFree(lPerIOData);
           //continue;
      }//if(lBytesTransferred == 0)

      if(lPerIOData->IOState == 0 )
      {		   
		   DataAnalysis(CompletionPort , lPerHandleData , lPerIOData , ThreadID);

	       ZeroMemory(&(lPerIOData->Overlapped), sizeof(OVERLAPPED));   
		   lPerIOData->BytesTrans = 0;
		   lPerIOData->DataBuf.len = DATA_BUFSIZE;	  
		   lPerIOData->DataBuf.buf = lPerIOData->Buffer;
		   DWORD Flags = 0;
		   //g_PerHandleData g_PerIData  Ÿ workerThread  ټ ִ.
		   if (WSARecv( lPerHandleData->Socket , &(lPerIOData->DataBuf), 1, &RecvBytes, &Flags,//Flags = 0
														 &(lPerIOData->Overlapped), NULL) == SOCKET_ERROR)
		   {
		    	 if (WSAGetLastError() != ERROR_IO_PENDING)
				 {
				     wsprintf(tBuf, "WSARecv() failed with error %d ServerWorkerThread \n", WSAGetLastError());
					 MessageBox(g_hWnd , tBuf , "iocp_Client", MB_OK);
				     return;
				 }
		   }//if (WSARecv(A		 	
		   continue;		   
      }//if(lPerHandleData->bRecv == true )
   
	  if(lPerIOData->IOState == 1)
	  {
			wsprintf(tBuf , " %dϿ %d Ʈ  " , lPerHandleData->client_i , lBytesTransferred);
			//SendMessage(g_hListBox, LB_INSERTSTRING, 0, (LPARAM)tBuf);
			continue;
	  }

	
   }//while(1)
}//void RecvWorkerThread




void DataAnalysis(HANDLE CompletionPort, LPPER_HANDLE_DATA lPerHandleData ,LPPER_IO_OPERATION_DATA lPerIOData , int ThreadID)
{
	char tBuf[100]= {0,};
	memcpy(lPerIOData->Buffer , lPerIOData->DataBuf.buf , sizeof(lPerIOData->Buffer)  );   
	int sock_i = lPerHandleData->client_i; 

	wsprintf(tBuf , "%s"  , lPerIOData->Buffer);		
    SendMessage(g_hListBox, LB_INSERTSTRING, 0, (LPARAM)tBuf);
	//
	//Ÿ ó κ...
	//
   
}//void DataAnalysis()