#include <gb.h>
#include <stdio.h>
#include <console.h>
#include "tettile.c"

char block[7][4][4][2]={
    { {{0,1},{1,1},{2,1},{3,1}},{{1,0},{1,1},{1,2},{1,3}},{{0,1},{1,1},{2,1},{3,1}},{{1,0},{1,1},{1,2},{1,3}} },
    { {{0,1},{1,1},{2,1},{2,2}},{{1,0},{1,1},{1,2},{2,0}},{{0,1},{1,1},{2,1},{0,0}},{{1,0},{1,1},{1,2},{0,2}} },    
    { {{0,1},{1,1},{2,1},{2,0}},{{1,0},{1,1},{1,2},{0,0}},{{0,1},{1,1},{2,1},{0,2}},{{1,0},{1,1},{1,2},{2,2}} },
    { {{0,1},{1,1},{2,1},{1,2}},{{1,0},{1,1},{1,2},{2,1}},{{0,1},{1,1},{2,1},{1,0}},{{1,0},{1,1},{1,2},{0,1}} },
    { {{1,0},{1,1},{0,1},{0,2}},{{0,0},{1,0},{1,1},{2,1}},{{1,0},{1,1},{0,1},{0,2}},{{0,0},{1,0},{1,1},{2,1}} },
    { {{0,0},{0,1},{1,1},{1,2}},{{2,0},{1,0},{1,1},{0,1}},{{0,0},{0,1},{1,1},{1,2}},{{2,0},{1,0},{1,1},{0,1}} },
    { {{0,0},{1,0},{0,1},{1,1}},{{0,0},{1,0},{0,1},{1,1}},{{0,0},{1,0},{0,1},{1,1}},{{0,0},{1,0},{0,1},{1,1}} }
     };

char blockcolor[7]={1,4,6,5,7,2,3};
unsigned char tiledata[]={0,1,2,3,4,5,6,7,8};

unsigned char msg_pre[]="PRESENTS";
unsigned char msg_score[]="SCORE";
unsigned char msg_hisc[]="HI_SC";
unsigned char msg_lines[]="LINES";
unsigned char msg_level[]="LEVEL";
unsigned char msg_next[]="NEXT_";
unsigned char msg_title[]="TETRIS_GAME";
unsigned char msg_dream[]="DREAMBIT_1999";
unsigned char msg_push[]="PUSH_START_BUTTON";
unsigned char msg_gover[]="GAME__OVER";

char sp[10][18];
char cl[10][18];
char x,y,b,d,c;
char nb,nd,nc;


char endflag;

long int score;
long int hisc;
long int lines;
int level;
int fallcount;

UWORD paldata[]={RGB(31,31,31),RGB(21,21,21),RGB(11,11,11),RGB(0,0,0),  /* black */
				RGB(31,31,31),RGB(31,21,21),RGB(31,11,11),RGB(31,0,0), /* red */
				RGB(31,31,31),RGB(21,31,21),RGB(11,31,11),RGB(0,31,0), /* green */
				RGB(31,31,31),RGB(21,21,31),RGB(11,11,31),RGB(0,0,31), /* blue */
				RGB(31,31,31),RGB(26,26,21),RGB(22,22,11),RGB(18,18,0), /* yellow */
				
				RGB(31,31,31),RGB(21,26,26),RGB(11,22,22),RGB(0,18,18), /* cyan */
				RGB(31,31,31),RGB(31,21,31),RGB(31,11,31),RGB(31,0,31), /* magneta */
				RGB(31,31,31),RGB(31,21,25),RGB(31,12,23),RGB(31,6,18)}; /* pink */


int n_rand(UWORD rand_max)
{
    int j;
    j = rand();
    j %= rand_max;
    return(j);
}


void inittile(){
    disable_interrupts(); 
    
    set_bkg_data(0,33,&tiles[0]);
    set_bkg_data('0',10,&font[0]);
    set_bkg_data('A',26,&font2[0]);
    
    enable_interrupts();
    
    DISPLAY_ON;
    SHOW_BKG;    
   	set_bkg_palette(0,8,&paldata[0]);
}

void logo(){
    char i,j;
    unsigned  char logodata[]={9,11,13,15,17,19,21,23,25,27,29,31,10,12,14,16,18,20,22,24,26,28,30,32};
    
    VBK_REG=1;
    for (i=0; i<12; i++)
        for(j=0;j<2;j++)
            set_bkg_tiles(4+i,6+j,1,1,&tiledata[1]);
    VBK_REG=0;    
    
    for (i=0; i<20; i++)
        for(j=0;j<18;j++)
            set_bkg_tiles(i,j,1,1,&tiledata[2]);
    set_bkg_tiles(4,6,12,2,&logodata[0]);
    set_bkg_tiles(6,9,8,1,msg_pre);
    delay(2000);
}


void title(){
    UBYTE jp;
    UWORD rd;
    char i,j;
    do{
        jp=joypad();
        if (!(jp&J_START)) break;
    }while(1);
        
    for (i=0; i<20; i++)
        for(j=0;j<18;j++)
            set_bkg_tiles(i,j,1,1,&tiledata[2]);
   set_bkg_tiles(4,3,11,1,msg_title);
   set_bkg_tiles(3,8,13,1,msg_dream);
   set_bkg_tiles(1,13,17,1,msg_push);
   
    do{
        jp=joypad();
        if (jp&J_START) break;
        rd++;
    }while(1);
    initrand(rd);    
}

void gameover(){
    UBYTE jp;
   set_bkg_tiles(2,5,10,1,msg_gover);
    do{
        jp=joypad();
        if (jp&J_START) break;
    }while(1);   
    if (hisc<score) hisc=score;
}

void putnum(char x,char y,long int num){
  unsigned char numdata[]={'0','1','2','3','4','5','6','7','8','9'};
  char numflag=0;
  long int num2;
  if (num>9999){
      numflag=1;
      num2=num/10000;
      set_bkg_tiles(x,y,1,1,&numdata[num2]);
  }
  else set_bkg_tiles(x,y,1,1,&tiledata[2]);  
  num=num%10000;
  if (num>999){
      numflag=1;
      num2=num/1000;
      set_bkg_tiles(x+1,y,1,1,&numdata[num2]);
  }else
      if (numflag==1)
          set_bkg_tiles(x+1,y,1,1,&numdata[0]);
      else set_bkg_tiles(x+1,y,1,1,&tiledata[2]);
  num=num%1000;
  if (num>99){
       numflag=1;
      num2=num/100;
      set_bkg_tiles(x+2,y,1,1,&numdata[num2]);
  }else
      if (numflag==1)
          set_bkg_tiles(x+2,y,1,1,&numdata[0]);
      else set_bkg_tiles(x+2,y,1,1,&tiledata[2]);
      
  num=num%100;
  if (num>9){
       numflag=1;
      num2=num/10;
      set_bkg_tiles(x+3,y,1,1,&numdata[num2]);
  }else
      if (numflag==1)
          set_bkg_tiles(x+3,y,1,1,&numdata[0]);
      else set_bkg_tiles(x+3,y,1,1,&tiledata[2]);      
  
  num=num%10;
  set_bkg_tiles(x+4,y,1,1,&numdata[num]);
}

void putscore()
{
    putnum(14,2,score);
    putnum(14,5,hisc);
    putnum(14,8,lines);
    putnum(14,11,level);
}

void initscr(){
    char i,j;
    unsigned char blank[10]={0,0,0,0,0,0,0,0,0,0};
    
    for (i=0; i<20; i++)
        for(j=0;j<18;j++){
            set_bkg_tiles(i,j,1,1,&tiledata[0]);
            VBK_REG=1;
            set_bkg_tiles(i,j,1,1,&tiledata[7]);
            VBK_REG=0;
    	}
    for(i=1;i<13;i++)    
        for(j=1;j<17;j++){
            set_bkg_tiles(i,j,1,1,&tiledata[2]);
        }
	VBK_REG=1;
    for(i=1;i<13;i++)    
        for(j=0;j<18;j++){
            set_bkg_tiles(i,j,1,1,&tiledata[0]);
        }	
	VBK_REG=0;
    for(i=2;i<12;i++){
        set_bkg_tiles(i,0,1,1,&tiledata[4]);
        set_bkg_tiles(i,17,1,1,&tiledata[4]);
    }
    for(i=1;i<17;i++){
        set_bkg_tiles(1,i,1,1,&tiledata[3]);
        set_bkg_tiles(12,i,1,1,&tiledata[3]);
    }
    set_bkg_tiles(1,0,1,1,&tiledata[5]);    
    set_bkg_tiles(12,0,1,1,&tiledata[6]);        
    set_bkg_tiles(1,17,1,1,&tiledata[7]);    
    set_bkg_tiles(12,17,1,1,&tiledata[8]);        
    
    set_bkg_tiles(14,1,5,1,msg_score);
    set_bkg_tiles(14,4,5,1,msg_hisc);
    set_bkg_tiles(14,7,5,1,msg_lines);
    set_bkg_tiles(14,10,5,1,msg_level);    
    set_bkg_tiles(14,13,5,1,msg_next);
    VBK_REG=1;
    set_bkg_tiles(14,1,5,2,&blank[0]);
    set_bkg_tiles(14,4,5,2,&blank[0]);
    set_bkg_tiles(14,7,5,2,&blank[0]);
    set_bkg_tiles(14,10,5,2,&blank[0]);
    set_bkg_tiles(14,13,5,1,&blank[0]);                
    VBK_REG=0;    
}

void putspace(){
    char i,j;
    for(i=0;i<10;i++)
        for(j=2;j<18;j++)
            if (sp[i][j]>0)
                set_bkg_tiles(2+i,j-1,1,1,&tiledata[1]);
                else 
                set_bkg_tiles(2+i,j-1,1,1,&tiledata[2]);
    VBK_REG=1;
    for(i=0;i<10;i++)
        for(j=2;j<18;j++)
           set_bkg_tiles(2+i,j-1,1,1,&tiledata[cl[i][j]]);
    VBK_REG=0;
}

void putblock(char num,char color){
    char i;
    if (color){
    VBK_REG=1;
    for(i=0;i<4;i++)
        if ((y+block[b][d][i][1])>1)
            set_bkg_tiles(2+x+block[b][d][i][0],y+block[b][d][i][1]-1,1,1,&tiledata[color]);
    VBK_REG=0;
    }       
    for(i=0;i<4;i++)
        if ((y+block[b][d][i][1])>1)
            set_bkg_tiles(2+x+block[b][d][i][0],y+block[b][d][i][1]-1,1,1,&tiledata[num]);

}

void putnextblock(char color){
    unsigned char blank[]={2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2};
    char i;
    set_bkg_tiles(14,14,4,4,&blank[0]);
    for(i=0;i<4;i++)
        set_bkg_tiles(14+block[nb][nd][i][0],14+block[nb][nd][i][1],1,1,&tiledata[1]);
    VBK_REG=1;
    for(i=0;i<4;i++)
        set_bkg_tiles(14+block[nb][nd][i][0],14+block[nb][nd][i][1],1,1,&tiledata[color]);
    VBK_REG=0;
}

char checkblock(char x2,char y2,char d2){
    char i;
    char xx,yy;
    for(i=0;i<4;i++){
        xx=x2+block[b][d2][i][0];
        yy=y2+block[b][d2][i][1];
        if (xx<0) return 0;
        if (xx>9) return 0;
        if (yy<0) return 0;
        if (yy>17) return 0;
        if (sp[xx][yy]>0) return 0;
    }
    return 1;
}

void initgame()
{
    int i,j;
    for(i=0;i<10;i++)
        for(j=0;j<18;j++)
            sp[i][j]=0;
   score=0;
   level=1;
   lines=0;
  do{
     nb=n_rand(7UL);
  }while ((nb<0)||(nb>6));   
  do{
     nd=n_rand(3UL);
  }while ((nd<0)||(nd>3));
  nc=blockcolor[nb];
}

void initblock(){
  x=4; y=0;
  b=nb; d=nd; c=nc;
  
  do{
     nb=n_rand(7UL);
  }while ((nb<0)||(nb>6));   
  do{
     nd=n_rand(4UL);
  }while ((nd<0)||(nd>3));  
  nc=blockcolor[nb];  

  putnextblock(nc);
  putblock(1,c);
  if (checkblock(x,y,d)==0) endflag=0;
 
}


void fallblock()
{
    char i;
    putblock(2,0);
    for(i=0;i<4;i++){
        sp[x+block[b][d][i][0]] [y+block[b][d][i][1]]=1;
        cl[x+block[b][d][i][0]] [y+block[b][d][i][1]]=c;
    }        
    putspace();
    score++;
}

void delblock()
{
    char i,j,k;
    char flag;
    char count=0;
    long int plus[]={0,100,300,600,1200};
    for(i=0;i<18;i++){
        flag=1;
        for(j=0;j<10;j++)
            if (sp[j][i]==0) flag=0;
        if (flag==1){
            count++;
            lines++;
            for(j=i;j>0;j--)
                for(k=0;k<10;k++){
                    sp[k][j]=sp[k][j-1];
                    cl[k][j]=cl[k][j-1];
                }
            for(k=0;k<10;k++){
                sp[k][0]=0; cl[k][0]=0; }
        }
   }
   putspace();
   score+=plus[count];
}


void moveblock()
{
    char temp;
    UBYTE jp;
    int i;
    int delc[10]={20,20,17,14,11,8,5,4,3,2};
    char up1=0, up2=0;
    int scoreplus=0;
    while(1){
        for(i=0;i<delc[level];i++){
            jp=joypad();
            if (jp&J_LEFT)
                if (checkblock(x-1,y,d)>0) { putblock(2,0); x--; putblock(1,c); }
            if (jp&J_RIGHT)
                if (checkblock(x+1,y,d)>0) { putblock(2,0); x++; putblock(1,c); }
            if (jp&J_DOWN) { scoreplus++; break; }
            up2=up1;
            if ((jp&J_UP)||(jp&J_A)) up1=1; else up1=0;
            
            if ((up2==0)&&(up1==1)){
               temp=d;
               temp++; if (temp>3) temp=0;
               if (checkblock(x,y,temp)>0) { putblock(2,0); d=temp; putblock(1,c); }
            }
            wait_vbl_done();
            delay(40);
        }
        if (checkblock(x,y+1,d)==0) break;
        putblock(2,0);
        y++;
        putblock(1,c);
        delay(40);
    }
    score+=scoreplus;
    fallcount++;
    if (fallcount>50) {
        fallcount=0;
        level++;
        if (level>9) level=9;
    }
}
                
main()
{
    UBYTE i,j;
    UBYTE jp;
    UBYTE num;
    
    inittile();    
    logo();

    do{   
    title();
    initscr();    
    initgame();
    putscore();    
    endflag=1;

    do{
          initblock();    
          moveblock(); 
          fallblock();
          delblock();
          putscore();
    }while(endflag); 
    gameover();
    }while(1);
    
    return 0;
}
