///////////////////////////////////////////////////
// FILE : CFile.cpp
// Desc : low-levle(stdio)Լ ̿ Wrapper Class Source
// Recently Update Date : 2001.05.16
///////////////////////////////////////////////////

#include "CFile.h"

CFile::CFile()
{
	CHAR  fileName[10] = {0};
	WORD  fileMode = 0;

	SYSTEMTIME    systemTime;
	ZeroMemory(&systemTime, sizeof(SYSTEMTIME));
	GetSystemTime(&systemTime);

	sprintf(fileName, "%d%d", systemTime.wMonth, systemTime.wDay);
	fileMode = VISION_CFILE_OPEN_TEXT  | VISION_CFILE_OPEN_WRITE;
	CFile(fileName, fileMode);
}

CFile::CFile(CHAR* arg_pFileName, WORD arg_mode)
{
	VISION_IS_VALID(arg_pFileName);

	// ɹ  ʱȭ
	m_file = NULL;
	if(VISION_IS_FAILED(SetFileName(arg_pFileName)))
	{
		// Error ó ؾ ϴ κ
		Vision_Error("̸  ");
	}
	m_mode        = arg_mode;
}

VISION_RESULT CFile::SetFileName(CHAR* arg_pFileName)
{	
	m_strFileName = NULL;
	m_strFileName = new CHAR[strlen(arg_pFileName) + 1];
	if(VISION_IS_INVALID(m_strFileName)) return VISION_FAILED;
	ZeroMemory(m_strFileName, strlen(arg_pFileName) + 1);
	strcpy(m_strFileName, arg_pFileName);
	return VISION_SUCCESS;
}

VISION_RESULT CFile::Open()
{
	switch(m_mode)
	{
	case VISION_CFILE_OPEN_BINARY | VISION_CFILE_OPEN_READ:
		m_file = fopen(m_strFileName, "rb");
		break;
	case VISION_CFILE_OPEN_BINARY | VISION_CFILE_OPEN_WRITE:
		m_file = fopen(m_strFileName, "wb");
		break;
	case VISION_CFILE_OPEN_TEXT   | VISION_CFILE_OPEN_READ:
		m_file = fopen(m_strFileName, "rt");
		break;
	case VISION_CFILE_OPEN_TEXT   | VISION_CFILE_OPEN_WRITE:
		m_file = fopen(m_strFileName, "wt");
		break;
	default: // Error
		return VISION_FAILED;
	}
	if(m_file == NULL)
	{
		return VISION_FAILED;
	}

	return VISION_SUCCESS;
}

VISION_RESULT CFile::Read(void* arg_buffer, DWORD arg_size)
{
	fread(arg_buffer, sizeof(CHAR), arg_size, m_file);
	return VISION_SUCCESS;
}


VISION_RESULT CFile::Write(const void* arg_buffer, DWORD arg_size)
{
	fwrite(arg_buffer, sizeof(CHAR), arg_size, m_file);
	return VISION_SUCCESS;
}

CHAR CFile::ReadCHAR()
{
	CHAR  temp;
	Read(&temp, sizeof(CHAR));
	return temp;
}

UCHAR CFile::ReadUCHAR()
{
	UCHAR  temp;
	Read(&temp, sizeof(UCHAR));
	return temp;
}

SHORT CFile::ReadINT16()
{
	SHORT  temp;
	Read(&temp, sizeof(SHORT));
	return temp;
}

USHORT CFile::ReadUINT16()
{
	USHORT  temp;
	Read(&temp, sizeof(USHORT));
	return temp;
}

INT CFile::ReadINT32()
{
	INT  temp;
	Read(&temp, sizeof(INT));
	return temp;
}

UINT CFile::ReadUINT32()
{
	UINT  temp;
	Read(&temp, sizeof(UINT));
	return temp;
}

VISION_RESULT CFile::Close()
{
	if(m_file != NULL)
		fclose(m_file);
	
	return VISION_SUCCESS;
}

CFile::~CFile()
{
	Close();

	m_file = NULL;
	m_mode = 0;

	if(m_strFileName != NULL)
		delete [] m_strFileName;
	m_strFileName = NULL;
}







