///////////////////////////////////////////////////
// FILE : CFile.h
// Desc : stdioԼ ̿ Wrapper Class Header
// Recently Update Date : 2001.05.16
///////////////////////////////////////////////////

#ifndef __VISION_CFILE_H__
#define __VISION_CFILE_H__

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#include <windows.h>
#include <string.h>
#include <stdio.h>

#include "VisionMacro.h"
#include "ErrorTable.h"
#include "ErrorFunction.h"

#define VISION_CFILE_OPEN_BINARY      0x08            
#define VISION_CFILE_OPEN_TEXT        0x04    
#define VISION_CFILE_OPEN_READ        0x02   
#define VISION_CFILE_OPEN_WRITE		  0x01
// #define VISION_CFILE_TRUNCATION     is not avaliable

class CFile 
{
public:
	// Constructor
	CFile();
	CFile(CHAR* arg_pFileName, WORD arg_mode);

	// Destructor
	~CFile();

	CHAR    ReadCHAR();
	UCHAR   ReadUCHAR();
	SHORT	ReadINT16();
	USHORT	ReadUINT16();
	INT		ReadINT32();
	UINT	ReadUINT32();

	VISION_RESULT	WriteUCHAR(UCHAR arg_buffer)
	{ return Write(&arg_buffer, sizeof(UCHAR)); }
	VISION_RESULT	WriteCHAR(CHAR arg_buffer)
	{ return Write(&arg_buffer, sizeof(CHAR)); }
	VISION_RESULT	WriteINT16(SHORT arg_buffer)
	{ return Write(&arg_buffer, sizeof(SHORT)); }
	VISION_RESULT	WriteUINT16(USHORT arg_buffer)
	{ return Write(&arg_buffer, sizeof(USHORT)); }
	VISION_RESULT	WriteINT32(INT arg_buffer)
	{ return Write(&arg_buffer, sizeof(INT)); }
	VISION_RESULT	WriteUINT32(UINT arg_buffer)
	{ return Write(&arg_buffer, sizeof(UINT)); }

	VISION_RESULT Read(void* arg_buffer, DWORD arg_size);
	VISION_RESULT Write(const void* arg_buffer, DWORD arg_size);
	
	VISION_RESULT	Open();
	VISION_RESULT   Close();

	VISION_RESULT SetFileName(CHAR* arg_pFileName); 

private:
	FILE*	m_file;
	WORD	m_mode;
	CHAR*	m_strFileName;
};

#endif //__VISION_CFILE_H__