/////////////////////////////////////////////////////
// FILE : WinMain.cpp
// Desc : Vision Engin Test α׷
// Update : 2001.05.16
/////////////////////////////////////////////////////

// INCLUDES //////////////////////////////////////////
#include "WinMain.h"

// INCLUDES //////////////////////////////////////////

void Error()
{
	MessageBox(g_hWnd, " ̻ Ҽ ϴ.", "", MB_OK);
	Clear();
	PostQuitMessage(1);
}


HBITMAP LoadBitmap(LPCSTR szBitmap, RECT bmInfo)
{
	HBITMAP hbm;

    hbm = (HBITMAP) LoadImage(GetModuleHandle(NULL), szBitmap, IMAGE_BITMAP, bmInfo.right,
                              bmInfo.bottom, LR_CREATEDIBSECTION);
    if (hbm == NULL)
        hbm = (HBITMAP) LoadImage(NULL, szBitmap, IMAGE_BITMAP, bmInfo.right, bmInfo.bottom,
                                  LR_LOADFROMFILE | LR_CREATEDIBSECTION);
    if (hbm == NULL)
        return NULL;

	return hbm;
}

void Init(int playerQTY, int prizeQTY)
{
	// ̹ ڿ Ҵִٸ ȯѴ.
	Clear();

	if(g_isPlay)
	{
		KillTimer(g_hWnd, ID_TIMER);
		g_isPlay = FALSE;
	}

	srand( (unsigned)time( NULL ) );

	// ٸ ׸  ϴ.
	g_penLadder = CreatePen(PS_SOLID, 10, RGB(rand() % 256, rand() % 256, rand() % 256));

	// 濡  Brush ϴ.
	g_brushBack = CreateSolidBrush(RGB(rand() % 256, rand() % 256, rand() % 256));

	// ٸ ϴ.
	int count = (playerQTY + 1) * LADDER_INTERVAL;
	g_patLadder = (BYTE*)malloc(count);
	if(IS_INVALID(g_patLadder))
		Error();

	ZeroMemory(g_patLadder, count);

	for(int i = LADDER_INTERVAL; i < count - LADDER_INTERVAL; i++)
	{
		*(g_patLadder + i) = rand() % 2;
	}
	
	BYTE* head  = g_patLadder + LADDER_INTERVAL;
	BYTE* tail = g_patLadder + (LADDER_INTERVAL*2);

	// ߿ : ٸ մϴ.(ٸ  Ģ  ʰϱ )
	for(i = 0; i < playerQTY - 2; i++)
	{
		for(int j = 0; j < LADDER_INTERVAL; j++)
		{
			if(*head == 1 && *tail == 1)
			*tail = 0;
			head++;
			tail++;
		}
	}

	// ÷̾ ϴ.
	g_player  = (PLAYER*)malloc(sizeof(PLAYER) * playerQTY);
	if(IS_INVALID(g_player))
		ERROR();

	ZeroMemory(g_player, sizeof(PLAYER) * playerQTY);
	for(i = 0; i < playerQTY; i++)
	{// ʱ ġ 
		g_player[i].x = (LADDER_WIDTH* i);
		g_player[i].y = 0;
		//   
		g_player[i].direction = LADDER_PLAYER_MOVE_DOWN;
		g_player[i].history   = LADDER_PLAYER_MOVE_DOWN;
	}

	// ÷̾  
	g_playerQTY = playerQTY;

	g_ptPrize = (POINT*)malloc(sizeof(POINT) * prizeQTY);
	if(IS_INVALID(g_ptPrize))
		ERROR();
	
	ZeroMemory(g_ptPrize, sizeof(POINT) * prizeQTY);

	// ÷  ϴ.(÷̾   ũٸ ÷̾  ÷ڴ .)
	int tempPrize;
	for(i = 0; i < prizeQTY; i++)
	{
		
		tempPrize = rand() % playerQTY;
	}

	for(i = 0; i < prizeQTY; i++)
	{
		g_ptPrize[i].x = LADDER_WIDTH * ((tempPrize + i) % playerQTY);
		g_ptPrize[i].y = LADDER_HEIGHT + LADDER_PRIZE_GAP;
	}

	// ο Դ ˱  
	g_ptIntersection.x = LADDER_WIDTH;
	g_ptIntersection.y = LADDER_HEIGHT / (LADDER_INTERVAL + 1);

	InvalidateRect(g_hWnd, NULL, FALSE);
}

void Clear()
{
	if(g_penLadder != NULL)
		DeleteObject(g_penLadder);

	if(g_brushBack != NULL)
		DeleteObject(g_brushBack);

	if(g_patLadder != NULL)
		free(g_patLadder);

	if(g_player != NULL)
		free(g_player);

	if(g_ptPrize != NULL)
		free(g_ptPrize);
}

void DrawLadder(HDC hdc)
{
	POINT iStart, iEnd;
	HPEN hPen;
	
	iStart.x = LADDER_START_POINT_X;
	iStart.y = LADDER_START_POINT_Y;
	
	iEnd.x   = LADDER_START_POINT_X;
	iEnd.y   = LADDER_START_POINT_Y + LADDER_HEIGHT;
	

	hPen = (HPEN)SelectObject(hdc, g_penLadder);
	
	//   ׸ϴ.
	for(int i = 0; i < g_playerQTY; i++)
	{
		MoveToEx(hdc, iStart.x, iStart.y, NULL);
		LineTo(hdc, iEnd.x, iEnd.y);

		iStart.x += LADDER_WIDTH;
		iEnd.x   += LADDER_WIDTH;
	}
	
	int interval = LADDER_HEIGHT / (LADDER_INTERVAL + 1);

	iStart.x = LADDER_START_POINT_X;
	iStart.y = LADDER_START_POINT_Y + interval;

	iEnd.x = iStart.x + LADDER_WIDTH;
	iEnd.y = iStart.y;

	BYTE* patLadder = g_patLadder + LADDER_INTERVAL;
	for(int j = 0; j < g_playerQTY - 1; j++)
	{
		for(int k = 0; k < LADDER_INTERVAL; k++)
		{
			if((*patLadder++) != 0)
			{
				//   ׸ϴ.
				MoveToEx(hdc, iStart.x, iStart.y, NULL);
				LineTo(hdc, iEnd.x, iEnd.y);
			}
			iStart.y += interval;
			iEnd.y = iStart.y;
		}
		iStart.x += LADDER_WIDTH;
		iStart.y = LADDER_START_POINT_Y + interval;

		iEnd.x = iStart.x + LADDER_WIDTH;
		iEnd.y = iStart.y;
	}

	SelectObject(hdc, hPen);
}

void DrawPlayer(HDC hdc)
{
	char buf[2];
	for(int i = 0; i < g_playerQTY; i++)
	{
		Ellipse(hdc, g_player[i].x - LADDER_PLAYER_SIZE + LADDER_START_POINT_X, g_player[i].y -LADDER_PLAYER_SIZE + LADDER_START_POINT_Y,
		     g_player[i].x + LADDER_PLAYER_SIZE + LADDER_START_POINT_X, g_player[i].y + LADDER_PLAYER_SIZE + LADDER_START_POINT_Y);
		sprintf(buf, "%i", i + 1);
		TextOut(hdc, g_player[i].x + LADDER_START_POINT_X - (LADDER_PLAYER_SIZE / 2), 
			g_player[i].y + LADDER_START_POINT_Y - (LADDER_PLAYER_SIZE / 2) , buf, sizeof(buf));
	}
}

void DrawPrize(HDC hdc)
{
	for(int i = 0; i < g_prizeQTY; i++)
	{
		TextOut(hdc, g_ptPrize[i].x + LADDER_START_POINT_X - (LADDER_PRIZE_WIDTH / 2), 
			g_ptPrize[i].y + LADDER_START_POINT_Y, g_szPrize, sizeof(g_szPrize));
	}
}

void Draw()
{
	HDC				hdc;         // handle to a device context
	PAINTSTRUCT     ps;          // used in WM_PAINT
	static          RECT rect = { 0, 0, LADDER_SCREEN_WIDTH, LADDER_SCREEN_HEIGHT};

	// simply validate the window
	hdc = BeginPaint(g_hWnd, &ps);

	//  
	FillRect(g_hdcMem, &rect, g_brushBack);

	// ٸ 
	DrawLadder(g_hdcMem);

	// Text  
	SetBkMode(g_hdcMem, TRANSPARENT);
	
	// ÷̾ 
	DrawPlayer(g_hdcMem);
	
	// ÷Ǵ  ǥ
	DrawPrize(g_hdcMem);

	BitBlt(hdc, 0, 0, 640, 480, g_hdcMem, 0, 0, SRCCOPY);

	EndPaint(g_hWnd, &ps);
}

void UpdateFrame()
{
	for(int i = 0; i < g_playerQTY; i++)
	{
		//   
		if(g_player[i].y >= LADDER_HEIGHT)
		{
			g_player[i].direction = LADDER_PLAYER_STOP;
		}
	}

	// ÷̾ Դϴ.
	for(i = 0; i < g_playerQTY; i++)
	{
		switch(g_player[i].direction)
		{
		case LADDER_PLAYER_MOVE_LEFT:
			g_player[i].x += -LADDER_PLAYER_SPEED;			
			break;
		case LADDER_PLAYER_MOVE_RIGHT:
			g_player[i].x += LADDER_PLAYER_SPEED;
			break;
		case LADDER_PLAYER_MOVE_DOWN:
			g_player[i].y += LADDER_PLAYER_SPEED;
			break;
		}
	}

	POINT ladderPosition;
	int curPosition;
	
	for(i = 0; i < g_playerQTY; i++)
	{
		// 濡 Դ Ȯ
		if(g_player[i].x % g_ptIntersection.x == 0 && 
			g_player[i].y % g_ptIntersection.y == 0)
		{
			if(g_player[i].history == LADDER_PLAYER_MOVE_DOWN)
			{
				ladderPosition.x = g_player[i].x / g_ptIntersection.x + 1;
				ladderPosition.y = g_player[i].y / g_ptIntersection.y - 1;
				
				curPosition = LADDER_INTERVAL * ladderPosition.x + ladderPosition.y;
				
				if(*(g_patLadder + curPosition - LADDER_INTERVAL))
				{
					g_player[i].direction = LADDER_PLAYER_MOVE_LEFT;
					g_player[i].history   = LADDER_PLAYER_MOVE_LEFT;
					continue;
				}
				
				if(*(g_patLadder + curPosition))
				{
					g_player[i].direction = LADDER_PLAYER_MOVE_RIGHT;
					g_player[i].history   = LADDER_PLAYER_MOVE_RIGHT;
					continue;
				}
			}
			g_player[i].direction = LADDER_PLAYER_MOVE_DOWN;
			g_player[i].history   = LADDER_PLAYER_MOVE_DOWN;
		}
	}
	InvalidateRect(g_hWnd, NULL, FALSE);
}

LRESULT CALLBACK WindowProc(HWND hWnd,
							UINT msg,
							WPARAM wParam,
							LPARAM lParam)
{
	// this is the main message handler of the system
//	PAINTSTRUCT     ps;          // used in WM_PAINT
//	HDC				hdc;         // handle to a device context

	// what is the message
	switch(msg)
	{
	case WM_COMMAND:
		{
			MenuHandler(wParam);
		}break;

	case WM_CREATE:
		{
			// do initialization stuff here
			HDC hdc;
			HBITMAP hBitmap;
			hdc = GetDC(hWnd);
			g_hdcMem = CreateCompatibleDC(hdc);
			hBitmap = CreateCompatibleBitmap(hdc, LADDER_SCREEN_WIDTH, LADDER_SCREEN_HEIGHT);
			
			SelectObject(g_hdcMem, hBitmap);			
			ReleaseDC(hWnd, hdc);
			g_prizeQTY = 1;
			g_playerQTY = 6;
			Init(g_playerQTY, g_playerQTY);
			
			// return sucess
			return 0;
		}break;
		
	case WM_PAINT:
		{	
			Draw();
			return 0;
		}break;

	case WM_DESTROY:
		{
			Clear();
			if(g_hdcMem)
				DeleteDC(g_hdcMem);
			// kill the application, this sends a WM_QUIT message
			PostQuitMessage(0);

			// return sucess
			return 0;
		}
	case WM_TIMER:
		{
			UpdateFrame();
		}break;

	default: break;
	} // end switch

	// process any message that we didn't take care of
	return DefWindowProc(hWnd, msg, wParam, lParam);

} // end WinProc

BOOL CALLBACK AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch(message)
	{
	case WM_INITDIALOG:
		return TRUE;
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		return TRUE;
		break;
	}
	return FALSE;
}

// Function name	: MenuHandler
// Description	    : ޴޼ ó  Լ
// Return type		: void 
// Argument         : WORD wParam -> WindowProc  wParam
void MenuHandler(WORD wParam)
{
	HMENU       hMenu;
	static int  iPlayerSelection = IDM_SETTING_PLAYER_SIX;
	static int  iPrizeSelection  = IDM_SETTING_PRIZE_ONE;
	static BOOL topMostToggle = FALSE;

	switch(LOWORD(wParam))
	{
	case IDM_SETTING_TOPMOST:
		if(topMostToggle)
		{
			SetWindowPos(g_hWnd, HWND_NOTOPMOST,
				NULL, NULL, NULL, NULL, SWP_SHOWWINDOW | SWP_NOSIZE | SWP_NOMOVE);
			topMostToggle = (!topMostToggle);
			hMenu = GetMenu(g_hWnd);
			CheckMenuItem(hMenu, IDM_SETTING_TOPMOST, MF_UNCHECKED);
		}
		else
		{
			SetWindowPos(g_hWnd, HWND_TOPMOST, 
				NULL, NULL, NULL, NULL, SWP_SHOWWINDOW | SWP_NOSIZE | SWP_NOMOVE);
			topMostToggle = (!topMostToggle);
			hMenu = GetMenu(g_hWnd);
			CheckMenuItem(hMenu, IDM_SETTING_TOPMOST, MF_CHECKED);
		}
		break;
	case IDM_ABOUT:
		DialogBox(g_hInstance, MAKEINTRESOURCE(ABOUTDLG), g_hWnd, AboutDlgProc);
		break;
	case IDM_EXIT:
		SendMessage(g_hWnd, WM_CLOSE, NULL, NULL);
		break;
	case IDM_SETTING_PLAYER_ONE: 
	case IDM_SETTING_PLAYER_TWO:
    case IDM_SETTING_PLAYER_THREE:
	case IDM_SETTING_PLAYER_FOUR:
	case IDM_SETTING_PLAYER_FIVE:
	case IDM_SETTING_PLAYER_SIX: 
		hMenu = GetMenu(g_hWnd);
		CheckMenuItem(hMenu, iPlayerSelection, MF_UNCHECKED);
		iPlayerSelection = LOWORD(wParam);
		CheckMenuItem(hMenu, iPlayerSelection, MF_CHECKED);
		switch(LOWORD(wParam))
		{
		case IDM_SETTING_PLAYER_ONE:   g_playerQTY = 1; Init(g_playerQTY, g_playerQTY); break;
		case IDM_SETTING_PLAYER_TWO:   g_playerQTY = 2; Init(g_playerQTY, g_playerQTY); break;
		case IDM_SETTING_PLAYER_THREE: g_playerQTY = 3; Init(g_playerQTY, g_playerQTY); break;
		case IDM_SETTING_PLAYER_FOUR:  g_playerQTY = 4; Init(g_playerQTY, g_playerQTY); break;
		case IDM_SETTING_PLAYER_FIVE:  g_playerQTY = 5; Init(g_playerQTY, g_playerQTY); break;
		case IDM_SETTING_PLAYER_SIX:   g_playerQTY = 6; Init(g_playerQTY, g_playerQTY); break;
		}
		break;

	case IDM_SETTING_PRIZE_ONE:
	case IDM_SETTING_PRIZE_TWO:
	case IDM_SETTING_PRIZE_THREE:
		hMenu = GetMenu(g_hWnd);
		CheckMenuItem(hMenu, iPrizeSelection, MF_UNCHECKED);
		iPrizeSelection = LOWORD(wParam);
		CheckMenuItem(hMenu, iPrizeSelection, MF_CHECKED);
		switch(LOWORD(wParam))
		{
		case IDM_SETTING_PRIZE_ONE:    g_prizeQTY = 1; Init(g_playerQTY, g_prizeQTY); break;
		case IDM_SETTING_PRIZE_TWO:    g_prizeQTY = 2; Init(g_playerQTY, g_prizeQTY); break;
		case IDM_SETTING_PRIZE_THREE:  g_prizeQTY = 3; Init(g_playerQTY, g_prizeQTY); break;
		}
		break;
	case IDM_RESET:	
		Init(g_playerQTY, g_prizeQTY);
		break;
	case IDM_START:// ٸ  
		g_isPlay = TRUE;
		SetTimer(g_hWnd, ID_TIMER, 33, NULL);
		break;
	}
}

// WINMAIN //////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hInstance,
										HINSTANCE hPrevInstance,
										LPSTR	  lpCmdLine,
										int		  nShowCmd)
{
	WNDCLASSEX		winClass; // this will hold the class we create
	HWND			hWnd;     // generic window handle
	MSG				msg;

	// first fill in the window class structure
	winClass.cbSize		  = sizeof(WNDCLASSEX);
	winClass.style		  = CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW;

	winClass.lpfnWndProc   = WindowProc;
	winClass.cbClsExtra	   = 0;
	winClass.cbWndExtra	   = 0;
	winClass.hInstance	   = hInstance;
	winClass.hIcon		   = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON));
	winClass.hCursor	   = LoadCursor(NULL, IDC_ARROW);
	winClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	winClass.lpszMenuName  = NULL;
	winClass.lpszClassName = WINDOW_CLASS_NAME;
	winClass.hIconSm	   = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON));

	// register the window class
	if(!RegisterClassEx(&winClass))
		return 0;

	// Client ũ 
	int iCaptionHeight = GetSystemMetrics(SM_CYCAPTION);
	int iFrameWidth    = GetSystemMetrics(SM_CXFIXEDFRAME);
	int iFrameHeight   = GetSystemMetrics(SM_CYFIXEDFRAME);
	int iMenuHeight    = GetSystemMetrics(SM_CYMENU);

	int iWindowWidth   = LADDER_SCREEN_WIDTH + (iFrameWidth << 1);
	int iWindowHeight  = LADDER_SCREEN_HEIGHT +	(iFrameHeight << 1) 
								+ iMenuHeight + iCaptionHeight;

	// create the window
	if(!(hWnd = CreateWindowEx(NULL,
							   WINDOW_CLASS_NAME,
						 	   "Your Basic Window",
						       WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX |WS_VISIBLE,
							   0, 0,
							   iWindowWidth, iWindowHeight,
							   NULL,
							   NULL,
							   hInstance,
							   NULL)))
		return 0;
	
	//  ڵ   ϱ 
	g_hWnd = hWnd;
	g_hInstance = hInstance;

	// load the menu resource
	HMENU hMenu = LoadMenu(hInstance, MAKEINTRESOURCE(IDR_MENU));

	// attach the menu to the window
	SetMenu(hWnd, hMenu);

	// enter main event loop
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	// return to windows like this
	return msg.wParam;

} // end WinMain
										