/////////////////////////////////////////////////////
// FILE : WinMain.h
// Desc : Vision Engin Testϱ  α׷ Header
// Update: 2001.05.16
/////////////////////////////////////////////////////
#ifndef __VISION_WINMAIN_H__
#define __VISION_WINMAIN_H__

// INCLUDES //////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN // just say no to MFC

#include <windows.h>        // include all the windows headers
#include <windowsx.h>       // include useful macros
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "resource.h"

/// DEFINES //////////////////////////////////////////
#define WINDOW_CLASS_NAME "VISION"

struct PLAYER
{
	int x;
	int y;
	int direction;
	int history;
};

// MACRO   //////////////////////////////
#define IS_INVALID(arg) (arg) != 0 ? FALSE : TRUE

// GLOBALS ///////////////////////////////////////////
// Variable ///////////////////////////////////////////
HWND g_hWnd = NULL;
HPEN   g_penLadder = NULL;
HBRUSH g_brushBack = NULL;
BYTE* g_patLadder = NULL;
PLAYER* g_player = NULL;
int g_playerQTY = 0;
int g_prizeQTY = 0;
HDC g_hdcMem = 0;
POINT g_ptIntersection;
BOOL g_isPlay = FALSE;
HINSTANCE g_hInstance;
POINT* g_ptPrize = NULL;
char g_szPrize[] = "÷";


// DEFINES /////////////////////////////////////////////
#define LADDER_WIDTH   100
#define LADDER_HEIGHT  300
#define LADDER_START_POINT_X 50
#define LADDER_START_POINT_Y 50
#define LADDER_INTERVAL      9

#define LADDER_PLAYER_SIZE         10
#define LADDER_PLAYER_MOVE_LEFT		0
#define LADDER_PLAYER_MOVE_RIGHT    1
#define LADDER_PLAYER_MOVE_DOWN     2
#define LADDER_PLAYER_STOP          3
#define LADDER_PLAYER_SPEED  10

#define LADDER_SCREEN_WIDTH   640
#define LADDER_SCREEN_HEIGHT  480

#define LADDER_PRIZE_GAP  20
#define LADDER_PRIZE_WIDTH 20


#define ID_TIMER 1

// GLOBALS ///////////////////////////////////////////
// Function //////////////////////////////////////////
LRESULT CALLBACK WindowProc(HWND, UINT, WPARAM, LPARAM);
int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int);

HBITMAP LoadBitmap(HDC hdc, LPCSTR szBitmap, RECT bmInfo);
void MenuHandler(WORD wParam);   // ޴ ڵ鷯

void Init(int playerQTY, int prizeQTY);        // ڿ Ҵ޴ Լ
void Clear(void);                //  ڿ ִ Լ
void UpdateFrame();              // Player  ̴ Լ


void Error();

void Draw(void);                 
void DrawPlayer(HDC hdc);
void DrawPrize(HDC hdc);
void DrawLadder(HDC hdc);  


#endif //__VISION_WINMAIN_H__