
#include "object.h"

object::object()
{
	this->iInternalRefID=0;
	this->cNextObj=NULL;
	this->cPrevObj=NULL;
	this->iFaces=0;
	this->iVertexes=0;
	this->iTexVertexes=0;
	this->iTexFaces=0;
	this->iNormals=0;
	this->iFaceNormals=0;
	this->iUseNormals=0;
	this->bTexture=true;
	this->iTexNum=0;
}

object::~object()
{
	/*
	delete this->fFaceNormal;
	delete this->fTexVertex;
	delete this->fVertex;
	delete this->fVertexNormal;
	delete this->iFace;
	*/
}

void object::GetDebugInfo()
{
	printf("ID: %d, Vertexes: %d, Faces %d, Texture Vertexes: %d\n", this->iInternalRefID, iVertexes, iFaces, iTexVertexes);
	printf("Texture Faces: %d, Normals: %d, Face Normals: %d\n", this->iTexFaces, this->iNormals, this->iFaceNormals);
	for (int i=0; i<this->iVertexes; i++)
	{
		printf("i: %d,\tx: %f,\t y: %f,\t z: %f\n", i+1,this->fVertex[i][0], this->fVertex[i][1], this->fVertex[i][2]);
	}
	for (i=0; i<this->iTexVertexes; i++)
	{
		printf("i: %d,\tx: %f,\t y: %f,\t z: %f\n", i+1,this->fTexVertex[i][0], this->fTexVertex[i][1], this->fTexVertex[i][2]);
	}
	for (i=0; i<this->iVertexes; i++)
	{
		printf("i: %d,\tx: %f,\t y: %f,\t z: %f\n", i+1,this->fVertexNormal[i][0], this->fVertexNormal[i][1], this->fVertexNormal[i][2]);
	}
	for (i=0; i<this->iFaces; i++)
	{
		printf("i: %d,\tx: %d,\t y: %d,\t z: %d\n", i+1,this->iFace[i][0], this->iFace[i][1], this->iFace[i][2]);
	}
	for (i=0; i<this->iTexFaces; i++)
	{
		printf("i: %d,\tx: %d,\t y: %d,\t z: %d\n", i+1,this->iTexFace[i][0], this->iTexFace[i][1], this->iTexFace[i][2]);
	}
	for (i=0; i<this->iFaceNormals; i++)
	{
		printf("i: %d,\tx: %f,\t y: %f,\t z: %f\n", i+1,this->fFaceNormal[i][0], this->fFaceNormal[i][1], this->fFaceNormal[i][2]);
	}


}

int object::GetIntRefID()
{
	return this->iInternalRefID;
}

void object::SetIntRefID(int iID)
{
	this->iInternalRefID=iID;
}

int object::LoadASEModel(char* pcFilename)
{
	char  data[255];
	FILE* ase;
	int i;
	ase=fopen("test.ase", "r");

	if (ase==NULL) return 1;

	// Zuerst sammeln wir mal allgemeine Info's...

	rewind(ase);
	
	while (!feof(ase))
	{
		fscanf(ase, "%s", &data);

		if ( !strcmp(data, "*MESH_NUMVERTEX") )  fscanf(ase, "%d", &this->iVertexes);
		if ( !strcmp(data, "*MESH_NUMFACES") ) 	 fscanf(ase, "%d", &this->iFaces);
		if ( !strcmp(data, "*MESH_NUMTVERTEX") ) fscanf(ase, "%d", &this->iTexVertexes);
		if ( !strcmp(data, "*MESH_NUMTVFACES") ) fscanf(ase, "%d", &this->iTexFaces);
		if ( !strcmp(data, "*MESH_NORMALS") )	 this->iUseNormals=1;
		this->iFaceNormals=this->iFaces;
	}

	/****************************
		Vertexes
	*****************************/

	
	// dann spulen wir den FilePointer wieder zum Anfang
	rewind(ase);

	// reservieren uns etwas speicher....voll im c++ style :-)

	this->fVertex = new float3[this->iVertexes];

	if (this->fVertex==NULL) return 2;

	// und sammeln mal die vertexes ein.....

	while (!feof(ase))
	{
		fscanf(ase, "%s", &data);
		
		if ( !strcmp(data, "*MESH_VERTEX") )
		{
			fscanf(ase, "%d", &i);
			fscanf(ase, "%f %f %f", &this->fVertex[i][0], &this->fVertex[i][2], &this->fVertex[i][1]);

			this->fVertex[i][2]= -this->fVertex[i][2];
		}
	}


	/****************************
		Texture Vertexes
	*****************************/


	// dann spulen wir den FilePointer wieder zum Anfang
	rewind(ase);

	// reservieren uns etwas speicher....voll im c++ style :-)

	this->fTexVertex = new float3[this->iTexVertexes];

	if (this->fTexVertex==NULL) return 2;

	// und sammeln mal die texture vertexes ein.....

	while (!feof(ase))
	{
		fscanf(ase, "%s", &data);
		
		if ( !strcmp(data, "*MESH_TVERT") )
		{
			fscanf(ase, "%d", &i);
			fscanf(ase, "%f %f %f", &this->fTexVertex[i][0], &this->fTexVertex[i][1], &this->fTexVertex[i][2]);
		}
	}
	
	/****************************
		Normals
	*****************************/


	// dann spulen wir den FilePointer wieder zum Anfang
	rewind(ase);

	if (this->iUseNormals==1) 
	{

		// reservieren uns etwas speicher....voll im c++ style :-)

		this->fVertexNormal = new float3[this->iVertexes];

		if (this->fVertexNormal==NULL) return 2;

		// und sammeln mal die normals ein.....

		while (!feof(ase))
		{
			fscanf(ase, "%s", &data);
			
			if ( !strcmp(data, "*MESH_VERTEXNORMAL") )
			{
				fscanf(ase, "%d", &i);
				fscanf(ase, "%f %f %f", &this->fVertexNormal[i][0], &this->fVertexNormal[i][2], &this->fVertexNormal[i][1]);
				this->fVertexNormal[i][2]= -this->fVertexNormal[i][2];
			}
		}
	}

	/****************************
		Faces
	*****************************/


	// dann spulen wir den FilePointer wieder zum Anfang
	rewind(ase);

	// reservieren uns etwas speicher....voll im c++ style :-)

	this->iFace= new int3[this->iFaces];

	if (this->iFace==NULL) return 2;

	// und sammeln mal die texture vertexes ein.....

	while (!feof(ase))
	{
		fscanf(ase, "%s", &data);
		
		if ( !strcmp(data, "*MESH_FACE") )
		{
			fscanf(ase, "%d:", &i);
			fscanf(ase, "\tA:\t%d B:\t%d C:\t%d", &this->iFace[i][0], &this->iFace[i][1], &this->iFace[i][2]);
		}
	}

	/****************************
		Texture Faces
	*****************************/


	// dann spulen wir den FilePointer wieder zum Anfang
	rewind(ase);

	// reservieren uns etwas speicher....voll im c++ style :-)

	this->iTexFace= new int3[this->iTexFaces];

	if (this->iTexFace==NULL) return 2;

	// und sammeln mal die texture vertexes ein.....

	while (!feof(ase))
	{
		fscanf(ase, "%s", &data);
		
		if ( !strcmp(data, "*MESH_TFACE") )
		{
			fscanf(ase, "%d:", &i);
			fscanf(ase, "%d %d %d", &this->iTexFace[i][0], &this->iTexFace[i][1], &this->iTexFace[i][2]);
		}
	}

	/****************************
		Face Normals
	*****************************/


	// dann spulen wir den FilePointer wieder zum Anfang
	rewind(ase);

	// reservieren uns etwas speicher....voll im c++ style :-)

	this->fFaceNormal= new float3[this->iFaceNormals];

	if (this->fFaceNormal==NULL) return 2;

	// und sammeln mal die texture vertexes ein.....


	while (!feof(ase))
	{
		fscanf(ase, "%s", &data);
		
		if ( !strcmp(data, "*MESH_FACENORMAL") )
		{
			fscanf(ase, "%d", &i);
			fscanf(ase, "%f %f %f", &this->fFaceNormal[i][0], &this->fFaceNormal[i][1], &this->fFaceNormal[i][2]);
		}
	}

	return 0;
}