#ifndef __OBJECT_H
#define __OBJECT_H

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

typedef float float3[3];
typedef int int3[3];

class object
{
	private:
		int iInternalRefID;
	public:
		object* cNextObj;
		object* cPrevObj;
		int iFaces;
		int iVertexes;
		int iTexVertexes;
		int iTexFaces;
		int iNormals;
		int iFaceNormals;
		int iUseNormals;
		bool bTexture;
		int iTexNum;

		float3* fVertex;
		float3* fTexVertex;
		int3* iFace;
		int3* iTexFace;
		float3* fFaceNormal;
		float3* fVertexNormal;

		object();
		~object();

		int LoadASEModel(char*);  // 0 = OK; 1 = File not found; 2 = Out of memory; 3 = Parse error; 10 = Unexpected or unknown error
		void GetDebugInfo();
		int GetIntRefID();
		void SetIntRefID(int);
};

#endif  