#include "game.h"




extern ascreenmode screen_mode;
extern byte keys[256];
extern int mousewheelcode;


unsigned long		seconds=0;
unsigned long		secondslast=0;
unsigned int		frames=0;
unsigned int		framespersecond=0;
unsigned long		ticktime=0;
unsigned long		ticktimelast=0;
unsigned long		timeelapsed=0;

extern HWND hWnd;

q3_player sonic;
q3_player homer;
md3_model railgun;

int anim_n=0;
extern atexture		*texture[MAX_TEXTURES];


int gameinit(void)
{

	console("---gremd3---");
	screen_mode.bpp=16;
	screen_mode.left=320;
	screen_mode.top=240;
	screen_mode.width=640;
	screen_mode.height=480;
	screen_mode.fullscreen=false;

	screen_mode.wireframe=false;
	screen_mode.lighting=false;
	screen_mode.textureson=true;
	screen_mode.cartoonmode=true;
	screen_mode.cell_shade=true;


	//load blank texture
	texture[0]=new atexture;
	strcpy(texture[0]->name,"null");	//fill name
	strcpy(texture[0]->filename,"blank.tga");	//fill name
	texture[0]->linear=1;
	loadtex(texture[0]);

	addtexture("1d","1d.tga");

/*	int oneDpos=0;
	findtexture("1d",&oneDpos);
	atexturedata *textureimage;
	textureimage=loadtexturefromfile("1d.tga");
	if (textureimage!=NULL)
	{
		glGenTextures(1,&texture[oneDpos]->data);

		glBindTexture(GL_TEXTURE_1D, texture[oneDpos]->data);
		glTexParameteri(GL_TEXTURE_1D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_1D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		glTexImage1D(GL_TEXTURE_1D, 0, GL_RGB, 32,0,textureimage->type,GL_UNSIGNED_BYTE, textureimage->data);

		if (textureimage->data)
			free(textureimage->data);
		free(textureimage);
	}
*/



	initmd3(&sonic.h);
	initmd3(&sonic.l);
	initmd3(&sonic.u);


	initmd3(&homer.h);
	initmd3(&homer.l);
	initmd3(&homer.u);

	//loadq3player(&homer,"ranger","default");
	loadq3player(&homer,"sonic","sonic");
	//loadq3player(&sonic,"sonic","supersonic");

	//setq3panim(&player,LEGS_RUN);
	anim_n=0;
	while(anim_n<LEGS_WALK+1)
	{
		setq3panim(&homer,anim_n);
		setq3panim(&sonic,anim_n);
		anim_n++;
	}


	loadmd3model(&railgun,"plasma\\plasma.md3");
//	loadmd3model(&railgun,"railgun\\railgun.md3");
	console("md3 model loaded");

	initmd3(&railgun);

	int railtex[4]={0};
/*
	addtexture("w_railgun1","railgun\\railgun1.tga");
	findtexture("w_railgun1",&railtex[0]);
	addtexture("w_railgun2","railgun\\railgun2.glow.tga");
	findtexture("w_railgun1",&railtex[1]);
	addtexture("w_railgun4","railgun\\railgun4.tga");
	findtexture("w_railgun1",&railtex[2]);
	addtexture("w_railgun3","railgun\\railgun3.glow.tga");
	findtexture("w_railgun1",&railtex[3]);
	//addtexture("w_railgun05","railgun\\railgun1.tga");

	setmeshtexture(&railgun,"w_railgun1", railtex[0]);
	setmeshtexture(&railgun,"w_railgun2", railtex[1]);
	setmeshtexture(&railgun,"w_railgun4", railtex[2]);
	setmeshtexture(&railgun,"w_railgun3", railtex[3]);
	setmeshtexture(&railgun,"w_railgun05", railtex[0]);
*/
	
	addtexture("w_plasma","plasma\\plasma.tga");
	findtexture("w_plasma",&railtex[0]);
	addtexture("w_plasma_glo","plasma\\plasma_glo.tga");
	findtexture("w_plasma_glo",&railtex[1]);

	setmeshtexture(&railgun,"w_plasma01", railtex[0]);
	setmeshtexture(&railgun,"w_plasma02", railtex[1]);
	setmeshtexture(&railgun,"w_plasma03", railtex[1]);
	setmeshtexture(&railgun,"w_plasma04", railtex[1]);

//	linkmodel(&sonic.u,"tag_weapon", &railgun);
	linkmodel(&homer.u,"tag_weapon", &railgun);

	return true;
}


int killgame(void)
{

	return true;
}

int gameloop(void)
{
	MSG msg;

	if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))	// Is There A Message Waiting?
	{
		if (msg.message==WM_QUIT)				// Have We Received A Quit Message?
		{
			return false;
		}
		else
		{
			TranslateMessage(&msg);				// Translate The Message
			DispatchMessage(&msg);				// Dispatch The Message
		}
	}

	updateinput();

	if (keys[VK_ESC]||keys['x'])
		return false;

	//new timing
	ticktimelast=ticktime;
	ticktime=timeplus(0);

	timeelapsed+=(ticktime-ticktimelast);
	
	secondslast=seconds;
	seconds=(timeelapsed/1000);
    
	#define MAX_FPS 70 //aka screen refresh rate

	float timedelta=((float)(ticktime-ticktimelast))*(1.0f/(float)MAX_FPS);

	if (seconds!=secondslast)
	{
		framespersecond=frames; 
		frames=0;
	}


	movecam(timedelta);

	
	//updateframetime(&model,ticktime);
	//updateframetime(&player.l,ticktime);
	updateq3player(&homer,(float)ticktime/1000);
	updateq3player(&sonic,(float)ticktime/1000);
	
	render();


	

	char wintxt[200]={0};
	sprintf(wintxt,"%d fps - %.4f delta",framespersecond,timedelta);

	SetWindowText(hWnd,wintxt);

	return true;
}


