#include "main.h"


extern int mousewheelcode;





LRESULT CALLBACK WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	switch (uMsg)									// Check For Windows Messages
	{
	/*	case WM_ACTIVATE:							// Watch For Window Activate Message
		{
			if (!HIWORD(wParam))					// Check Minimization State
			{
				active=TRUE;						// Program Is Active
			}
			else
			{
				active=FALSE;						// Program Is No Longer Active
			}

			return 0;								// Return To The Message Loop
		}
*/
		case WM_SYSCOMMAND:							// Intercept System Commands
		{
			switch (wParam)							// Check System Calls
			{
				case SC_SCREENSAVE:					// Screensaver Trying To Start?
				case SC_MONITORPOWER:				// Monitor Trying To Enter Powersave?
				return 0;							// Prevent From Happening
			}
			break;									// Exit
		}

		case WM_CLOSE:								// Did We Receive A Close Message?
		{
			quitgame();
			return 0;
		}

/*
		case WM_KEYDOWN:							// Is A Key Being Held Down?
		{
			keys[vktochar(wParam)] = TRUE;

			return 0;								// Jump Back
		}

		case WM_KEYUP:								// Has A Key Been Released?
		{
			keys[vktochar(wParam)] = FALSE;					// If So, Mark It As FALSE
			return 0;								// Jump Back
		}
		*/
/*
		case WM_SIZE:								// Resize The OpenGL Window
		{
			ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));  // LoWord=Width, HiWord=Height
			return 0;								// Jump Back
		}
		*/

		case WM_MOUSEWHEEL:
		{
			if ((short)HIWORD(wParam) > 0)
				mousewheelcode=WHEEL_UP;
			else
				mousewheelcode=WHEEL_DOWN;
			return 0;
		}

	}

	// Pass All Unhandled Messages To DefWindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}


long timeplus(long plusmilsecs)
{
	return timeGetTime()+plusmilsecs;
}




int quitgame(void)
{
	console("posted quit msg");
	PostQuitMessage(0);
	return true;
}



int main(int argc,char *argv)
{
	if (!gameinit())
	{
		console("failed to init game.");
		return 0;
	}


	console("starting vid...");
	if (vidrestart())
		console("video restarted");
	else
	{
		console("video failed to start");
		return 0;
	}

	

	while(gameloop());

	if (killglwindow())
		console("killed video");
	else
		console("couldnt kill video");

	killgame();

	return 0;
}