#ifndef MD3_H
#define MD3_H

#include <windows.h>
#include <stdio.h>

#include "texture.h"
#include "render.h"


typedef struct
{ 
	char		id[4];			// id = IDP3
	int		version;			// version = 15
	char		filename[68];
	int		numBoneFrames;
	int		numTags;
	int		numMeshes;
	int		numMaxSkins;
	int		headerlength;
	int		tag_start;
	int		tag_end;
	int		filesize;
} md3_header_t;
	
typedef struct
{
	float	mins[3];
	float	maxs[3];
	float	position[3];
	float	scale;
	char		creator[16];
} boneframe_t;

typedef struct
{
	char		name[64];
	float	position[3];
	float	rotation[3][3];
} tag_t;

typedef struct
{
	char		id[4];
	char		name[68];
	int		numMeshFrames;
	int		numSkins;
	int      numVertexs;
	int		numTriangles;
	int		tri_start;
	int		headersize;
	int      texvec_start;
	int		vertex_start;
	int		meshsize;
} mesh_header_t;

typedef struct
{
	char		name[68];
} skin_t;

typedef struct
{
	int		vertex[3];
} triangle_t;

typedef struct
{
	float	texvec[2];
} tex_coord_t;

typedef struct
{
	signed		short	Vec[3];
	unsigned	char	Normal[2];
} vertice_t;

typedef struct
{
	mesh_header_t	mesh_h;
	skin_t			*skins;
	triangle_t		*triangles;
	tex_coord_t		*tex_coords;
	vertice_t		*vertices;
	int texture_n;
//	CTexture		texture;
} mesh_t;

typedef struct
{
	int		first_frame, num_frames, looping_frames, frames_per_second;
} anim_t;

typedef enum {
	BOTH_DEATH1,
	BOTH_DEAD1,
	BOTH_DEATH2,
	BOTH_DEAD2,
	BOTH_DEATH3,
	BOTH_DEAD3,

	TORSO_GESTURE,

	TORSO_ATTACK,
	TORSO_ATTACK2,

	TORSO_DROP,
	TORSO_RAISE,

	TORSO_STAND,
	TORSO_STAND2,

	LEGS_WALKCR,
	LEGS_WALK,
	LEGS_RUN,
	LEGS_BACK,
	LEGS_SWIM,

	LEGS_JUMP,
	LEGS_LAND,

	LEGS_JUMPB,
	LEGS_LANDB,

	LEGS_IDLE,
	LEGS_IDLECR,

	LEGS_TURN,

	MAX_ANIMATIONS
} animNumber_t;

char *GetAnimName(int a);


typedef struct
{
	int				frame;			// curent frame to draw
	int				nextframe;		// next frame to draw
	int				fps;			// frames per second
	
	int				startframe;
	int				endframe;
	//int				loopframes;

	float			oldTime;
	float			newTime;

	int				tex_nr;			// using for LoadSkin (*.skin)
//	atexture	*tex_inf[100];	// using for LoadSkin (*.skin)
	int texture_id;
	char			*md3name;		// name for the md3 file

	md3_header_t	header;
	boneframe_t		*boneframes;
	tag_t			*tags;
	mesh_t			*meshes;

	void		**links;
	//md3_model
} md3_model;


typedef struct
{
	md3_model	 l, u, h;
	anim_t		anim[25];

	int				anim_l;
	int				anim_u;

	float			oldTime;
	float			newTime;
} q3_player;







void drawskeleton(md3_model *model);
int CheckFile(char *filename);
char *GetAnimName(int a);
int ParsNum(const char *str);
char *COM_Parse (char *data);
int initmd3(md3_model *model);
int destroymd3(md3_model *model);
int loadmd3model(md3_model *model,char *filename);
void md3infodump(md3_model *model);
void drawmodelframe(md3_model *model,int curFrame);
void drawiltpframe(md3_model *model,int curFrame, int nextFrame, float pol);
void drawmodel(md3_model *model);
void updateframetime(md3_model *model,float time);
void quat_from_matrix( float *quat, float *m );
void quat_slerp(float *from, float *to, float t, float *res);
void matrix_from_quat( float *m, float *quat );
int linkmodel(md3_model *model,char *tagname,md3_model *md3link);
void unlinkmodel(md3_model *model,char *tagname);
void loadskin(md3_model *model,char *filename, char *imagepath);
void loadq3playeranim(q3_player *q3p,char *filename);
void setq3panim(q3_player *q3p,int a);
int loadq3player(q3_player *q3p,char *path, char *skin);
void drawq3player(q3_player *q3p);
void updateq3player(q3_player *q3p,float time);
void setallmeshestexure(md3_model *model,int tex_id);
int setmeshtexture(md3_model *model,char *meshname,int tex_id);

#endif