#ifndef TEXTURE_H
#define TEXTURE_H


#include "glstuff.h"


#define MAX_TEXTURES 99



typedef struct {
	GLuint data;
	byte linear;//bool-1 on
	char name[100];
	char filename[256];
} atexture;

typedef struct {
	GLint	sizeX, sizeY;
	GLuint	type;
    GLubyte *data;
} atexturedata;

typedef struct _TargaHeader
{
	unsigned char 	id_length, colormap_type, image_type;
	unsigned short	colormap_index, colormap_length;
	unsigned char	colormap_size;
	unsigned short	x_origin, y_origin, width, height;
	unsigned char	pixel_size, attributes;
} TargaHeader;


void LoadFileTGA(char *name, unsigned char **pixels, int *width, int *height,GLuint *rgb_type);
atexturedata *loadTGA(char *filename);
atexturedata *loadtexturefromfile(char *filename);
int loadtex(atexture *thistexture);
int addtexture(char *texturename,char *filename);
int findtexture(char *texturename,int *position);
int deletetexture(int position);
int freetexture(int position);


#endif