#include "Cursor.h"

CCursor::CCursor()
{

}

CCursor::~CCursor()
{
	DestroyObject();
}

BOOL CCursor::Create(CDisplay *pDisplay, int width, int height)
{
	
	m_pSurface = new CSurface();
	m_pSurface->Create( pDisplay->GetDirectDraw(), width, height);
	m_pSurface->SetColorKey(0);
	m_pSurface->LoadBmp("Cursor.bmp");

	m_bShow = FALSE;

	return TRUE;
}

BOOL CCursor::DestroyObject()
{
	SAFE_DELETE( m_pSurface);

	return TRUE;
}

VOID CCursor::Proc( UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch ( msg)
	{
		case WM_MOUSEMOVE:
			m_point.x = LOWORD(lParam);
			m_point.y = HIWORD(lParam);
			break;

		case WM_LBUTTONDOWN:
			m_wLButton = LDOWN;
			m_wClicked = LDOWN;
			break;
		
		case WM_LBUTTONUP:
			m_wLButton = LUP;
			if(m_wClicked == LDOWN) m_wClicked = LCLICK;
			break;

		case WM_RBUTTONDOWN:
			m_wRButton = RDOWN;
			m_wClicked = RDOWN;
			break;

		case WM_RBUTTONUP:
			m_wRButton = RUP;
			if( m_wClicked == RDOWN) m_wClicked = RCLICK;
			break;

	}
	
}

VOID CCursor::SetShow( int x, int y, BOOL value)
{
	m_point.x = x;
	m_point.y = y;
	m_bShow = value;
	SetCursorPos(x, y);
}

VOID CCursor::SetPos(int x, int y)
{
	m_point.x = x;
	m_point.y = y;
	SetCursorPos( x, y);
}
