#ifndef _CURSOR_H_
#define _CURSOR_H_

#include <ddraw.h>
#include "DirectDraw.h"
#include "Surface.h"
#include "Global.h"

#define LUP			0x0000
#define LDOWN		0x0001
#define LCLICK		0x0002
#define RUP			0x0000
#define RDOWN		0x0100
#define RCLICK      0x0200


class CCursor;

class CCursor
{

public:
	CCursor();
	~CCursor();

	CSurface * m_pSurface;
	POINT m_point;
	WORD  m_wClicked;
	WORD  m_wLButton; 
	WORD  m_wRButton;
	BOOL  m_bShow;

public:
	BOOL Create( CDisplay* pDisplay, int width, int height);
	virtual BOOL DestroyObject();
	VOID Proc( UINT msg, WPARAM wParam, LPARAM lParam);
	
	WORD  GetLButton()  {	return m_wLButton; }
	WORD  GetRButton()  {	return m_wRButton; }
	WORD  GetClicked()	{	return m_wClicked; }
	VOID  ClearClicked() { m_wClicked=0; }		// 0x0000
	
	VOID  SetShow(int x, int y, BOOL value);
	BOOL  GetShow() { return m_bShow; }
	VOID  SetPos (int x, int y);
	LPPOINT GetPos () { return &m_point; }

};

#endif