#include "directdraw.h"

CDisplay::CDisplay()
{
	m_pDD				= NULL;
	m_pddsFrontBuffer	= NULL;
	m_pddsBackBuffer	= NULL;
	
	m_bWindowed = FALSE;		// Window Mode Setting
}

CDisplay::~CDisplay()
{
	DestroyObjects();
}

HRESULT CDisplay::DestroyObjects()
{
	SAFE_RELEASE( m_pddsBackBuffer);
	SAFE_RELEASE( m_pddsFrontBuffer);

	if( m_pDD)
		m_pDD->SetCooperativeLevel( m_hWnd, DDSCL_NORMAL);
	SAFE_RELEASE( m_pDD);

	return S_OK;
}

HRESULT CDisplay::CreateFullScreenDisplay( HWND hWnd, DWORD dwWidth, DWORD dwHeight, DWORD dwBPP)
{
	DestroyObjects();

	DirectDrawCreateEx(NULL, (VOID**)&m_pDD, IID_IDirectDraw7, NULL);
	m_pDD->SetCooperativeLevel(hWnd, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
	m_pDD->SetDisplayMode( dwWidth, dwHeight, dwBPP, 0, 0);

	DDSURFACEDESC2 ddsd;
	ZeroMemory( &ddsd, sizeof (ddsd) );
	ddsd.dwSize			= sizeof(ddsd);
	ddsd.dwFlags		= DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	m_pDD->CreateSurface ( &ddsd, &m_pddsFrontBuffer, NULL);

	DDSCAPS2 ddscaps;
	ZeroMemory( &ddscaps, sizeof(ddscaps));
	ddscaps.dwCaps	= DDSCAPS_BACKBUFFER;
	m_pddsFrontBuffer->GetAttachedSurface( &ddscaps, &m_pddsBackBuffer);

	m_hWnd = hWnd;
	UpdateBounds();

	return S_OK;
}

HRESULT CDisplay::CreateWindowedDisplay( HWND hWnd, DWORD dwWidth, DWORD dwHeight)
{

	DestroyObjects();

	DirectDrawCreateEx( NULL, (VOID**)&m_pDD, IID_IDirectDraw7, NULL);

	m_pDD->SetCooperativeLevel( hWnd, DDSCL_NORMAL);

	RECT rcWork;
	RECT rc;
	DWORD dwStyle;

	dwStyle = GetWindowStyle( hWnd);
	dwStyle &= ~WS_POPUP;
	dwStyle |= WS_OVERLAPPED|WS_CAPTION|WS_THICKFRAME| WS_MINIMIZEBOX;
	SetWindowLong ( hWnd, GWL_STYLE, dwStyle);

	SetRect ( &rc, 0, 0, dwWidth, dwHeight);

	AdjustWindowRectEx ( &rc, GetWindowStyle(hWnd), GetMenu(hWnd) !=NULL, GetWindowExStyle(hWnd));

	SetWindowPos( hWnd, NULL, 0, 0, rc.right-rc.left, rc.bottom-rc.top,
				SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
	SetWindowPos( hWnd, HWND_NOTOPMOST, 0, 0, 0, 0,
				SWP_NOSIZE|SWP_NOMOVE|SWP_NOACTIVATE);

	SystemParametersInfo( SPI_GETWORKAREA, 0, &rcWork, 0);
	GetWindowRect( hWnd, &rc);
	if( rc.left < rcWork.left) rc.left = rcWork.left;
	if( rc.top  < rcWork.top ) rc.top  = rcWork.top;
	SetWindowPos( hWnd, NULL, rc.left, rc.top, 0, 0,
					SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);

	LPDIRECTDRAWCLIPPER pcClipper;

	DDSURFACEDESC2 ddsd;
	ZeroMemory ( &ddsd, sizeof(ddsd));
	ddsd.dwSize	= sizeof( ddsd);
	ddsd.dwFlags	= DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

	m_pDD->CreateSurface( &ddsd, &m_pddsFrontBuffer, NULL);

	ddsd.dwFlags  = DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth	= dwWidth;
	ddsd.dwHeight   = dwHeight;

	m_pDD->CreateSurface( &ddsd, &m_pddsBackBuffer, NULL);

	m_pDD->CreateClipper( 0, &pcClipper, NULL);
	pcClipper->SetHWnd(0, hWnd);
	m_pddsFrontBuffer->SetClipper(pcClipper);
	pcClipper->Release();
	
	m_hWnd = hWnd;
	UpdateBounds();

	return S_OK;
}



HRESULT CDisplay::UpdateBounds()
{
	if( m_bWindowed)
	{
		GetClientRect( m_hWnd, &m_rcWindow);
		ClientToScreen( m_hWnd, (POINT*)&m_rcWindow);
		ClientToScreen( m_hWnd, (POINT*)&m_rcWindow+1);
	}
	else
	{
		SetRect( &m_rcWindow, 0, 0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));
	}

	return S_OK;
}

HRESULT CDisplay::Clear( DWORD dwColor )
{
	DDBLTFX ddbltfx;
	ZeroMemory(&ddbltfx, sizeof(ddbltfx));
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = dwColor;

	return m_pddsBackBuffer->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);
}


HRESULT CDisplay::Present()
{
	HRESULT hr;

	while(1)
	{
		if( m_bWindowed)
			hr = m_pddsFrontBuffer->Blt( &m_rcWindow, m_pddsBackBuffer,
										NULL, DDBLT_WAIT, NULL);
		else
			hr = m_pddsFrontBuffer->Flip(NULL, 0);

		if( hr == DDERR_SURFACELOST)
		{
			m_pddsFrontBuffer->Restore();
			m_pddsBackBuffer->Restore();
		}

		if( hr != DDERR_WASSTILLDRAWING)	//  while   ƾ
			return hr;
	}
}

VOID CDisplay::Lock()
{
	ZeroMemory(&m_ddsd, sizeof(m_ddsd));
	m_ddsd.dwSize = sizeof(m_ddsd);
	m_pddsBackBuffer->Lock(NULL, &m_ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR, NULL);
	m_pBackPtr = (WORD*) m_ddsd.lpSurface;
}

VOID CDisplay::Unlock()
{
	m_pddsBackBuffer->Unlock(NULL);
}

VOID CDisplay::PutPixel(int sx, int sy, WORD dwColor)
{
	m_pBackPtr[sx+sy*m_ddsd.lPitch/2] = dwColor;
}

VOID CDisplay::ColorBox( int sx, int sy, int width, int height, WORD dwColor)
{

	for(int y = 0; y< height; y++)
		for( int x = 0; x< width; x++)
			m_pBackPtr[sx+x+(sy+y)*m_ddsd.lPitch/2] = dwColor;

}		


HRESULT CDisplay::OutText(HFONT hFont, int sx, int sy, TCHAR* strText, COLORREF crTextColor, COLORREF crBackground)
{
	HDC			hDC	= NULL;

	m_pddsBackBuffer->GetDC( &hDC);

	if( crBackground == NULL)
		SetBkMode(hDC, TRANSPARENT);
	else
		SetBkColor( hDC, crBackground);	

	SetTextColor ( hDC, crTextColor);

	if( hFont)
	{
		SelectObject ( hDC, hFont);
	}

	TextOut( hDC, sx, sy, strText, _tcslen(strText));

	m_pddsBackBuffer->ReleaseDC( hDC);

	return S_OK;
}
