#ifndef _DIRECTDRAW_H_
#define _DIRECTDRAW_H_

#include <tchar.h>
#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>
#include <malloc.h>
#include <memory.h>
#include "Global.h"

class CDisplay;

class CDisplay
{
protected:
	LPDIRECTDRAW7			m_pDD;
	LPDIRECTDRAWSURFACE7	m_pddsFrontBuffer;
	LPDIRECTDRAWSURFACE7	m_pddsBackBuffer;

	HWND					m_hWnd;
	RECT					m_rcWindow;
	BOOL					m_bWindowed;

	DDSURFACEDESC2			m_ddsd;
		
public:
	WORD*					m_pBackPtr;		// : Back Surface Memory Pointer 

	CDisplay();
	~CDisplay();

	HWND					GetHWnd()		{ return m_hWnd; }
	LPDIRECTDRAW7			GetDirectDraw()	{ return m_pDD; }
	LPDIRECTDRAWSURFACE7	GetFrontBuffer(){ return m_pddsFrontBuffer; }
	LPDIRECTDRAWSURFACE7	GetBackBuffer()	{ return m_pddsBackBuffer; }
	long					GetLPitch()		{ return m_ddsd.lPitch; }

	BOOL					IsWindowed()	{ return m_bWindowed; }
	HRESULT	CreateFullScreenDisplay( HWND hWnd, DWORD dwWidth, DWORD dwHeight, DWORD dwBPP);
	HRESULT CreateWindowedDisplay ( HWND hWnd, DWORD dwWidth, DWORD dwHeight);
	HRESULT UpdateBounds();
	virtual	HRESULT DestroyObjects();
	HRESULT Clear( DWORD dwColor = 0L);
	HRESULT Present();
	VOID Lock();
	VOID Unlock();
	VOID PutPixel(int sx, int sy, WORD dwColor);
	VOID ColorBox(int sx, int sy, int width, int height, WORD dwColor);
	HRESULT OutText(HFONT hFont, int sx, int sy, TCHAR* string, COLORREF crTextColor, COLORREF crBackground);

};


#endif