#include "Font.h"

CFont::CFont()
{

}

CFont::~CFont()
{
	DestroyObject();
}

BOOL CFont::CreateFonts()
{
	m_hFontNormal		= CreateUserFont(12,0,0,0);
	m_hFontItalic		= CreateUserFont(12,1,0,0);
	m_hFontUnderline	= CreateUserFont(12,0,1,0);

	return TRUE;
}


HFONT CFont::CreateUserFont(int nSize, BOOL bItalic, BOOL bUnderline, BOOL bStrikeOut)
{

	HFONT hFont;
	hFont = CreateFont(		12,					// nHeight
							0,					// nWidth
							0,					
							0,	
							0,					// nWeight
							bItalic,			// Italic
							bUnderline,			// Underline
							bStrikeOut,			// StrikeOut
							HANGUL_CHARSET,		// JOHAB_CHARSET
							OUT_TT_PRECIS,		// OUT_DEFAULT_PRECIS		
							CLIP_TT_ALWAYS,		// CLIP_DEFAULT_PRECIS		 
							PROOF_QUALITY,		// DEFAULT_QUALITY
							FF_DECORATIVE,		// FF_DONTCARE
							NULL);

	return hFont;
}


BOOL CFont::DestroyObject()
{
	
	DeleteObject(m_hFontNormal);
	DeleteObject(m_hFontItalic);
	DeleteObject(m_hFontUnderline);

	return TRUE;
}

