#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include <windows.h>
#include <mmsystem.h>

#define SAFE_DELETE(p)  { if(p) { delete (p); (p)=NULL; }}
#define SAFE_RELEASE(p) { if(p) { (p)->Release(); (p)=NULL; } }

// 5:5:5
// #define RGB16(R,G,B) ((((unsigned char)(R)>>3)<<10)+(((unsigned char)(G)>>3)<<5)+(((unsigned char)(B)>>3)))
#define RGB16(R,G,B) ((((unsigned char)(R)>>3)<<11)+(((unsigned char)(G)>>2)<<5)+(((unsigned char)(B)>>3)))

// 5:5:5
// #define dALPHA_MASK1 0x7c1f03e0
// #define dALPHA_MASK2 0x03e07c1f
// #define dHALF_MASK	0x7bde
#define dALPHA_MASK1 0xf81f //07e0
#define dALPHA_MASK2 0x07e0 //f81f
#define dHALF_MASK	 0xf7de

#define NORMAL		g_pFont->m_hFontNormal			// Font  CFont ־
#define ITALIC		g_pFont->m_hFontItalic			//    Define.
#define UNDERLINE	g_pFont->m_hFontUnderline

#define GRAY_1		RGB(150,150,150)
#define GRAY_2		RGB(170,170,170)

void DebugMessage( LPCSTR String);

//-----------------------------------------------------------------------------
// Name: DXUtil_Timer()
// Desc: Performs timer opertations. Use the following commands:
//          TIMER_RESET           - to reset the timer
//          TIMER_START           - to start the timer
//          TIMER_STOP            - to stop (or pause) the timer
//          TIMER_ADVANCE         - to advance the timer by 0.1 seconds
//          TIMER_GETABSOLUTETIME - to get the absolute system time
//          TIMER_GETAPPTIME      - to get the current time
//          TIMER_GETELAPSEDTIME  - to get the time that elapsed between 
//                                  TIMER_GETELAPSEDTIME calls
//-----------------------------------------------------------------------------
enum TIMER_COMMAND { TIMER_RESET, TIMER_START, TIMER_STOP, TIMER_ADVANCE,
                     TIMER_GETABSOLUTETIME, TIMER_GETAPPTIME, TIMER_GETELAPSEDTIME};
FLOAT __stdcall DXUtil_Timer( TIMER_COMMAND command );


#endif