#include "Surface.h"

CSurface::CSurface()
{
	m_pdds			= NULL;
	m_bColorKeyed	= NULL;

	m_pBmp = new CBmp();
}

CSurface::~CSurface()
{
	SAFE_DELETE( m_pBmp);
	SAFE_RELEASE( m_pdds);
}

HRESULT CSurface::Create( LPDIRECTDRAW7 pDD, DWORD dwWidth, DWORD dwHeight)
{
	HRESULT hr;
	DDSURFACEDESC2 ddsd;
	
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize			= sizeof(ddsd);
	ddsd.dwFlags		= DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	m_x = ddsd.dwWidth		= dwWidth;
	m_y = ddsd.dwHeight	= dwHeight;
		
	hr = pDD->CreateSurface( &ddsd, &m_pdds, NULL);
	
	return S_OK;
}

HRESULT CSurface::Destroy()
{
	SAFE_RELEASE( m_pdds);
	return S_OK;
}

HRESULT CSurface::SetColorKey( DWORD dwColorKey)
{
	m_bColorKeyed = TRUE;

	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue  = ConvertGDIColor( dwColorKey);
	ddck.dwColorSpaceHighValue = ConvertGDIColor( dwColorKey);

	return m_pdds->SetColorKey( DDCKEY_SRCBLT, &ddck);
}


// ConvertGDIColor( dwGDIColor )
// dwGDIColor  ǥ鿡     ϴ Լ
DWORD CSurface::ConvertGDIColor( COLORREF dwGDIColor)	
{
	COLORREF		rgbT;				
	HDC				hdc;				
	DWORD			dw = CLR_INVALID;	
	DDSURFACEDESC2	ddsd;				
	HRESULT			hr;					

	if( dwGDIColor != CLR_INVALID && m_pdds->GetDC(&hdc) == DD_OK)
	{
		rgbT = GetPixel(hdc, 0, 0 );			
		SetPixel( hdc, 0, 0, dwGDIColor);		
		m_pdds->ReleaseDC(hdc);
	}

	ddsd.dwSize = sizeof(ddsd);
	hr = m_pdds->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL);	
	if( hr == DD_OK)
	{
		dw = *(DWORD*) ddsd.lpSurface;					
		if( ddsd.ddpfPixelFormat.dwRGBBitCount<32)		
			dw &= (1 <<ddsd.ddpfPixelFormat.dwRGBBitCount) -1; 
		m_pdds->Unlock(NULL);
	}

	if( dwGDIColor != CLR_INVALID && m_pdds->GetDC(&hdc) == DD_OK)	
	{
		SetPixel(hdc, 0, 0, rgbT);
		m_pdds->ReleaseDC( hdc);
	}

	return dw;
}

HRESULT CSurface::OutText(HFONT hFont, DWORD dwX, DWORD dwY, TCHAR *strText, COLORREF crTextColor, COLORREF crBackground)
{
	HDC hDC = NULL;

	m_pdds->GetDC( &hDC);


	if( crBackground == NULL)
		SetBkMode(hDC, TRANSPARENT);
	else
		SetBkColor( hDC, crBackground);	
	
	SetTextColor( hDC, crTextColor);

	if( hFont)
		SelectObject( hDC, hFont);

	TextOut( hDC, dwX, dwY, strText, _tcslen( strText));

	m_pdds->ReleaseDC( hDC);

	return S_OK;
}

HRESULT CSurface::Clear( DWORD dwColor )
{
	DDBLTFX ddbltfx;
	ZeroMemory(&ddbltfx, sizeof(ddbltfx));
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = dwColor;

	return m_pdds->Blt(NULL,NULL,NULL,DDBLT_COLORFILL,&ddbltfx);
}

VOID CSurface::Lock()
{
	ZeroMemory(&m_ddsd, sizeof(m_ddsd));
	m_ddsd.dwSize = sizeof(m_ddsd);
	m_pdds->Lock(NULL, &m_ddsd, DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR, NULL);
	m_pPtr = (WORD*) m_ddsd.lpSurface;
}


VOID CSurface::Unlock()
{
	m_pdds->Unlock(NULL);
}


HRESULT CSurface::LoadBmp( TCHAR * filename)
{
	m_pBmp->LoadBmp( filename);

	Lock();
	DWORD y;
	for(y=0; y<m_pBmp->m_dwY; y++)
	{
		memcpy(m_pPtr+y*GetLPitch()/2,m_pBmp->image.data+y* m_pBmp->m_dwX*2 ,m_pBmp->m_dwX*2);
	}
	Unlock();


	return S_OK;
}

VOID CSurface::Alpha(WORD srcColor)
{
	Lock();

	WORD backColor, halfColor;
	
	for(int y=0; y< m_y; y++)
		for(int x=0; x<m_x; x++)
		{
			backColor = m_pPtr[x+y*GetLPitch()/2];
			halfColor = ((backColor&dHALF_MASK)>>1) +	
						((srcColor&dHALF_MASK)>>1);
		

			m_pPtr[x+y*GetLPitch()/2] = halfColor;
		}
	
	Unlock();
}

VOID CSurface::Alpha2(int alphaDepth, WORD destColor)
{
	int destDepth= 32-alphaDepth;
	WORD srcColor;

	for( int y=0 ; y< m_y; y++)
	for( int x=0;  x< m_x; x++)
	{
		

		destColor = destColor&dALPHA_MASK1;
		destColor >>= 5;
		destColor *= destDepth;
		destColor &= dALPHA_MASK1;


		srcColor = m_pPtr[x+y*GetLPitch()/2];
		srcColor =		srcColor&dALPHA_MASK1;
		srcColor >>=	5;
		srcColor *=	alphaDepth;
		srcColor &=	dALPHA_MASK1;
		
		m_pPtr[x+y*GetLPitch()/2] = srcColor | destColor;
	}
}



