#ifndef _SURFACE_H_
#define _SURFACE_H_

#include <ddraw.h>
#include <tchar.h>
#include "Global.h"
#include "Bmp.h"

class CSurface;

class CSurface
{
protected:
	LPDIRECTDRAWSURFACE7 m_pdds;
	DDSURFACEDESC2		 m_ddsd;
	BOOL				 m_bColorKeyed;
	int					 m_x, m_y;

	DWORD	ConvertGDIColor( COLORREF dwGDIColor);

public:
	LPDIRECTDRAWSURFACE7 GetDDrawSurface()	{ return m_pdds; }
	BOOL				 IsColorKeyed()		{ return m_bColorKeyed; }

	CBmp * m_pBmp;
	WORD*					m_pPtr;		// : Surface Memory Pointer 
	DWORD*					m_pPtr32;
	
	long					GetLPitch()		{ return m_ddsd.lPitch; }
	VOID			Lock();
	VOID			Unlock();

	HRESULT SetColorKey( DWORD dwColorkey );
	HRESULT Create ( LPDIRECTDRAW7 pDD, DWORD dwWidth, DWORD dwHeight);
	HRESULT Destroy();

	HRESULT OutText( HFONT hFont, DWORD dwX, DWORD dwY, TCHAR *strText, COLORREF crTextColor, COLORREF crBackground);
	HRESULT Clear( DWORD dwColor = 0L);

	HRESULT LoadBmp( TCHAR * filename);
	VOID Alpha( WORD srcColor);
	VOID Alpha2( int alphaDepth , WORD destColor);

	CSurface();
	~CSurface();
};

#endif